// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AccessPackageAssignmentPolicy;
import com.microsoft.graph.requests.AccessPackageWithReferenceRequestBuilder;
import com.microsoft.graph.requests.AccessPackageCatalogWithReferenceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package Assignment Policy Request.
 */
public class AccessPackageAssignmentPolicyRequest extends BaseRequest<AccessPackageAssignmentPolicy> {
	
    /**
     * The request for the AccessPackageAssignmentPolicy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AccessPackageAssignmentPolicyRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AccessPackageAssignmentPolicy.class);
    }

    /**
     * Gets the AccessPackageAssignmentPolicy from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageAssignmentPolicy> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AccessPackageAssignmentPolicy from the service
     *
     * @return the AccessPackageAssignmentPolicy from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageAssignmentPolicy get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageAssignmentPolicy> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AccessPackageAssignmentPolicy delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AccessPackageAssignmentPolicy with a source
     *
     * @param sourceAccessPackageAssignmentPolicy the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageAssignmentPolicy> patchAsync(@Nonnull final AccessPackageAssignmentPolicy sourceAccessPackageAssignmentPolicy) {
        return sendAsync(HttpMethod.PATCH, sourceAccessPackageAssignmentPolicy);
    }

    /**
     * Patches this AccessPackageAssignmentPolicy with a source
     *
     * @param sourceAccessPackageAssignmentPolicy the source object with updates
     * @return the updated AccessPackageAssignmentPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageAssignmentPolicy patch(@Nonnull final AccessPackageAssignmentPolicy sourceAccessPackageAssignmentPolicy) throws ClientException {
        return send(HttpMethod.PATCH, sourceAccessPackageAssignmentPolicy);
    }

    /**
     * Creates a AccessPackageAssignmentPolicy with a new object
     *
     * @param newAccessPackageAssignmentPolicy the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageAssignmentPolicy> postAsync(@Nonnull final AccessPackageAssignmentPolicy newAccessPackageAssignmentPolicy) {
        return sendAsync(HttpMethod.POST, newAccessPackageAssignmentPolicy);
    }

    /**
     * Creates a AccessPackageAssignmentPolicy with a new object
     *
     * @param newAccessPackageAssignmentPolicy the new object to create
     * @return the created AccessPackageAssignmentPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageAssignmentPolicy post(@Nonnull final AccessPackageAssignmentPolicy newAccessPackageAssignmentPolicy) throws ClientException {
        return send(HttpMethod.POST, newAccessPackageAssignmentPolicy);
    }

    /**
     * Creates a AccessPackageAssignmentPolicy with a new object
     *
     * @param newAccessPackageAssignmentPolicy the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessPackageAssignmentPolicy> putAsync(@Nonnull final AccessPackageAssignmentPolicy newAccessPackageAssignmentPolicy) {
        return sendAsync(HttpMethod.PUT, newAccessPackageAssignmentPolicy);
    }

    /**
     * Creates a AccessPackageAssignmentPolicy with a new object
     *
     * @param newAccessPackageAssignmentPolicy the object to create/update
     * @return the created AccessPackageAssignmentPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessPackageAssignmentPolicy put(@Nonnull final AccessPackageAssignmentPolicy newAccessPackageAssignmentPolicy) throws ClientException {
        return send(HttpMethod.PUT, newAccessPackageAssignmentPolicy);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AccessPackageAssignmentPolicyRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AccessPackageAssignmentPolicyRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

