// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.RecurrenceRangeType;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Recurrence Range.
 */
public class RecurrenceRange implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The End Date.
     * The date to stop applying the recurrence pattern. Depending on the recurrence pattern of the event, the last occurrence of the meeting may not be this date. Required if type is endDate.
     */
    @SerializedName(value = "endDate", alternate = {"EndDate"})
    @Expose
	@Nullable
    public com.microsoft.graph.core.DateOnly endDate;

    /**
     * The Number Of Occurrences.
     * The number of times to repeat the event. Required and must be positive if type is numbered.
     */
    @SerializedName(value = "numberOfOccurrences", alternate = {"NumberOfOccurrences"})
    @Expose
	@Nullable
    public Integer numberOfOccurrences;

    /**
     * The Recurrence Time Zone.
     * Time zone for the startDate and endDate properties. Optional. If not specified, the time zone of the event is used.
     */
    @SerializedName(value = "recurrenceTimeZone", alternate = {"RecurrenceTimeZone"})
    @Expose
	@Nullable
    public String recurrenceTimeZone;

    /**
     * The Start Date.
     * The date to start applying the recurrence pattern. The first occurrence of the meeting may be this date or later, depending on the recurrence pattern of the event. Must be the same value as the start property of the recurring event. Required.
     */
    @SerializedName(value = "startDate", alternate = {"StartDate"})
    @Expose
	@Nullable
    public com.microsoft.graph.core.DateOnly startDate;

    /**
     * The Type.
     * The recurrence range. The possible values are: endDate, noEnd, numbered. Required.
     */
    @SerializedName(value = "type", alternate = {"Type"})
    @Expose
	@Nullable
    public RecurrenceRangeType type;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
