// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UnifiedRoleEligibilityScheduleRequest;
import com.microsoft.graph.models.RoleEligibilityScheduleRequestFilterByCurrentUserOptions;
import com.microsoft.graph.requests.AppScopeWithReferenceRequestBuilder;
import com.microsoft.graph.requests.DirectoryObjectWithReferenceRequestBuilder;
import com.microsoft.graph.requests.UnifiedRoleDefinitionWithReferenceRequestBuilder;
import com.microsoft.graph.requests.UnifiedRoleEligibilityScheduleWithReferenceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Unified Role Eligibility Schedule Request Request.
 */
public class UnifiedRoleEligibilityScheduleRequestRequest extends BaseRequest<UnifiedRoleEligibilityScheduleRequest> {
	
    /**
     * The request for the UnifiedRoleEligibilityScheduleRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UnifiedRoleEligibilityScheduleRequestRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UnifiedRoleEligibilityScheduleRequest.class);
    }

    /**
     * Gets the UnifiedRoleEligibilityScheduleRequest from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleEligibilityScheduleRequest> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UnifiedRoleEligibilityScheduleRequest from the service
     *
     * @return the UnifiedRoleEligibilityScheduleRequest from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRoleEligibilityScheduleRequest get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleEligibilityScheduleRequest> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UnifiedRoleEligibilityScheduleRequest delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UnifiedRoleEligibilityScheduleRequest with a source
     *
     * @param sourceUnifiedRoleEligibilityScheduleRequest the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleEligibilityScheduleRequest> patchAsync(@Nonnull final UnifiedRoleEligibilityScheduleRequest sourceUnifiedRoleEligibilityScheduleRequest) {
        return sendAsync(HttpMethod.PATCH, sourceUnifiedRoleEligibilityScheduleRequest);
    }

    /**
     * Patches this UnifiedRoleEligibilityScheduleRequest with a source
     *
     * @param sourceUnifiedRoleEligibilityScheduleRequest the source object with updates
     * @return the updated UnifiedRoleEligibilityScheduleRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRoleEligibilityScheduleRequest patch(@Nonnull final UnifiedRoleEligibilityScheduleRequest sourceUnifiedRoleEligibilityScheduleRequest) throws ClientException {
        return send(HttpMethod.PATCH, sourceUnifiedRoleEligibilityScheduleRequest);
    }

    /**
     * Creates a UnifiedRoleEligibilityScheduleRequest with a new object
     *
     * @param newUnifiedRoleEligibilityScheduleRequest the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleEligibilityScheduleRequest> postAsync(@Nonnull final UnifiedRoleEligibilityScheduleRequest newUnifiedRoleEligibilityScheduleRequest) {
        return sendAsync(HttpMethod.POST, newUnifiedRoleEligibilityScheduleRequest);
    }

    /**
     * Creates a UnifiedRoleEligibilityScheduleRequest with a new object
     *
     * @param newUnifiedRoleEligibilityScheduleRequest the new object to create
     * @return the created UnifiedRoleEligibilityScheduleRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRoleEligibilityScheduleRequest post(@Nonnull final UnifiedRoleEligibilityScheduleRequest newUnifiedRoleEligibilityScheduleRequest) throws ClientException {
        return send(HttpMethod.POST, newUnifiedRoleEligibilityScheduleRequest);
    }

    /**
     * Creates a UnifiedRoleEligibilityScheduleRequest with a new object
     *
     * @param newUnifiedRoleEligibilityScheduleRequest the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRoleEligibilityScheduleRequest> putAsync(@Nonnull final UnifiedRoleEligibilityScheduleRequest newUnifiedRoleEligibilityScheduleRequest) {
        return sendAsync(HttpMethod.PUT, newUnifiedRoleEligibilityScheduleRequest);
    }

    /**
     * Creates a UnifiedRoleEligibilityScheduleRequest with a new object
     *
     * @param newUnifiedRoleEligibilityScheduleRequest the object to create/update
     * @return the created UnifiedRoleEligibilityScheduleRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRoleEligibilityScheduleRequest put(@Nonnull final UnifiedRoleEligibilityScheduleRequest newUnifiedRoleEligibilityScheduleRequest) throws ClientException {
        return send(HttpMethod.PUT, newUnifiedRoleEligibilityScheduleRequest);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UnifiedRoleEligibilityScheduleRequestRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UnifiedRoleEligibilityScheduleRequestRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

