// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AccessPackageAssignment;
import com.microsoft.graph.models.AccessPackageAssignmentFilterByCurrentUserOptions;
import com.microsoft.graph.requests.AccessPackageWithReferenceRequestBuilder;
import com.microsoft.graph.requests.AccessPackageAssignmentPolicyWithReferenceRequestBuilder;
import com.microsoft.graph.requests.AccessPackageSubjectWithReferenceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package Assignment Request Builder.
 */
public class AccessPackageAssignmentRequestBuilder extends BaseRequestBuilder<AccessPackageAssignment> {

    /**
     * The request builder for the AccessPackageAssignment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AccessPackageAssignmentRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the AccessPackageAssignmentRequest instance
     */
    @Nonnull
    public AccessPackageAssignmentRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the AccessPackageAssignmentRequest instance
     */
    @Nonnull
    public AccessPackageAssignmentRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.AccessPackageAssignmentRequest(getRequestUrl(), getClient(), requestOptions);
    }



    /**
     * Gets the request builder for AccessPackage
     *
     * @return the AccessPackageWithReferenceRequestBuilder instance
     */
    @Nonnull
    public AccessPackageWithReferenceRequestBuilder accessPackage() {
        return new AccessPackageWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("accessPackage"), getClient(), null);
    }

    /**
     * Gets the request builder for AccessPackageAssignmentPolicy
     *
     * @return the AccessPackageAssignmentPolicyWithReferenceRequestBuilder instance
     */
    @Nonnull
    public AccessPackageAssignmentPolicyWithReferenceRequestBuilder assignmentPolicy() {
        return new AccessPackageAssignmentPolicyWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("assignmentPolicy"), getClient(), null);
    }

    /**
     * Gets the request builder for AccessPackageSubject
     *
     * @return the AccessPackageSubjectWithReferenceRequestBuilder instance
     */
    @Nonnull
    public AccessPackageSubjectWithReferenceRequestBuilder target() {
        return new AccessPackageSubjectWithReferenceRequestBuilder(getRequestUrlWithAdditionalSegment("target"), getClient(), null);
    }

    /**
     * Gets a builder to execute the method
     * @return the request builder
     */
    @Nonnull
    public AccessPackageAssignmentReprocessRequestBuilder reprocess() {
        return new AccessPackageAssignmentReprocessRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.reprocess"), getClient(), null);
    }
}
