// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.LicenseDetails;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the License Details Request.
 */
public class LicenseDetailsRequest extends BaseRequest<LicenseDetails> {
	
    /**
     * The request for the LicenseDetails
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public LicenseDetailsRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, LicenseDetails.class);
    }

    /**
     * Gets the LicenseDetails from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LicenseDetails> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the LicenseDetails from the service
     *
     * @return the LicenseDetails from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LicenseDetails get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LicenseDetails> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public LicenseDetails delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this LicenseDetails with a source
     *
     * @param sourceLicenseDetails the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LicenseDetails> patchAsync(@Nonnull final LicenseDetails sourceLicenseDetails) {
        return sendAsync(HttpMethod.PATCH, sourceLicenseDetails);
    }

    /**
     * Patches this LicenseDetails with a source
     *
     * @param sourceLicenseDetails the source object with updates
     * @return the updated LicenseDetails
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LicenseDetails patch(@Nonnull final LicenseDetails sourceLicenseDetails) throws ClientException {
        return send(HttpMethod.PATCH, sourceLicenseDetails);
    }

    /**
     * Creates a LicenseDetails with a new object
     *
     * @param newLicenseDetails the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LicenseDetails> postAsync(@Nonnull final LicenseDetails newLicenseDetails) {
        return sendAsync(HttpMethod.POST, newLicenseDetails);
    }

    /**
     * Creates a LicenseDetails with a new object
     *
     * @param newLicenseDetails the new object to create
     * @return the created LicenseDetails
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LicenseDetails post(@Nonnull final LicenseDetails newLicenseDetails) throws ClientException {
        return send(HttpMethod.POST, newLicenseDetails);
    }

    /**
     * Creates a LicenseDetails with a new object
     *
     * @param newLicenseDetails the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<LicenseDetails> putAsync(@Nonnull final LicenseDetails newLicenseDetails) {
        return sendAsync(HttpMethod.PUT, newLicenseDetails);
    }

    /**
     * Creates a LicenseDetails with a new object
     *
     * @param newLicenseDetails the object to create/update
     * @return the created LicenseDetails
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public LicenseDetails put(@Nonnull final LicenseDetails newLicenseDetails) throws ClientException {
        return send(HttpMethod.PUT, newLicenseDetails);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public LicenseDetailsRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public LicenseDetailsRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

