// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.Attendee;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.DateTimeTimeZone;
import com.microsoft.graph.models.Importance;
import com.microsoft.graph.models.Location;
import com.microsoft.graph.models.OnlineMeetingInfo;
import com.microsoft.graph.models.OnlineMeetingProviderType;
import com.microsoft.graph.models.Recipient;
import com.microsoft.graph.models.PatternedRecurrence;
import com.microsoft.graph.models.ResponseStatus;
import com.microsoft.graph.models.Sensitivity;
import com.microsoft.graph.models.FreeBusyStatus;
import com.microsoft.graph.models.EventType;
import com.microsoft.graph.models.Attachment;
import com.microsoft.graph.models.Calendar;
import com.microsoft.graph.models.Extension;
import com.microsoft.graph.models.Event;
import com.microsoft.graph.models.MultiValueLegacyExtendedProperty;
import com.microsoft.graph.models.SingleValueLegacyExtendedProperty;
import com.microsoft.graph.models.OutlookItem;
import com.microsoft.graph.requests.AttachmentCollectionPage;
import com.microsoft.graph.requests.ExtensionCollectionPage;
import com.microsoft.graph.requests.EventCollectionPage;
import com.microsoft.graph.requests.MultiValueLegacyExtendedPropertyCollectionPage;
import com.microsoft.graph.requests.SingleValueLegacyExtendedPropertyCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Event.
 */
public class Event extends OutlookItem implements IJsonBackedObject {


    /**
     * The Allow New Time Proposals.
     * true if the meeting organizer allows invitees to propose a new time when responding; otherwise false. Optional. Default is true.
     */
    @SerializedName(value = "allowNewTimeProposals", alternate = {"AllowNewTimeProposals"})
    @Expose
	@Nullable
    public Boolean allowNewTimeProposals;

    /**
     * The Attendees.
     * The collection of attendees for the event.
     */
    @SerializedName(value = "attendees", alternate = {"Attendees"})
    @Expose
	@Nullable
    public java.util.List<Attendee> attendees;

    /**
     * The Body.
     * The body of the message associated with the event. It can be in HTML or text format.
     */
    @SerializedName(value = "body", alternate = {"Body"})
    @Expose
	@Nullable
    public ItemBody body;

    /**
     * The Body Preview.
     * The preview of the message associated with the event. It is in text format.
     */
    @SerializedName(value = "bodyPreview", alternate = {"BodyPreview"})
    @Expose
	@Nullable
    public String bodyPreview;

    /**
     * The End.
     * The date, time, and time zone that the event ends. By default, the end time is in UTC.
     */
    @SerializedName(value = "end", alternate = {"End"})
    @Expose
	@Nullable
    public DateTimeTimeZone end;

    /**
     * The Has Attachments.
     * Set to true if the event has attachments.
     */
    @SerializedName(value = "hasAttachments", alternate = {"HasAttachments"})
    @Expose
	@Nullable
    public Boolean hasAttachments;

    /**
     * The Hide Attendees.
     * When set to true, each attendee only sees themselves in the meeting request and meeting Tracking list. Default is false.
     */
    @SerializedName(value = "hideAttendees", alternate = {"HideAttendees"})
    @Expose
	@Nullable
    public Boolean hideAttendees;

    /**
     * The ICal UId.
     * A unique identifier for an event across calendars. This ID is different for each occurrence in a recurring series. Read-only.
     */
    @SerializedName(value = "iCalUId", alternate = {"ICalUId"})
    @Expose
	@Nullable
    public String iCalUId;

    /**
     * The Importance.
     * 
     */
    @SerializedName(value = "importance", alternate = {"Importance"})
    @Expose
	@Nullable
    public Importance importance;

    /**
     * The Is All Day.
     * 
     */
    @SerializedName(value = "isAllDay", alternate = {"IsAllDay"})
    @Expose
	@Nullable
    public Boolean isAllDay;

    /**
     * The Is Cancelled.
     * 
     */
    @SerializedName(value = "isCancelled", alternate = {"IsCancelled"})
    @Expose
	@Nullable
    public Boolean isCancelled;

    /**
     * The Is Draft.
     * 
     */
    @SerializedName(value = "isDraft", alternate = {"IsDraft"})
    @Expose
	@Nullable
    public Boolean isDraft;

    /**
     * The Is Online Meeting.
     * 
     */
    @SerializedName(value = "isOnlineMeeting", alternate = {"IsOnlineMeeting"})
    @Expose
	@Nullable
    public Boolean isOnlineMeeting;

    /**
     * The Is Organizer.
     * 
     */
    @SerializedName(value = "isOrganizer", alternate = {"IsOrganizer"})
    @Expose
	@Nullable
    public Boolean isOrganizer;

    /**
     * The Is Reminder On.
     * 
     */
    @SerializedName(value = "isReminderOn", alternate = {"IsReminderOn"})
    @Expose
	@Nullable
    public Boolean isReminderOn;

    /**
     * The Location.
     * 
     */
    @SerializedName(value = "location", alternate = {"Location"})
    @Expose
	@Nullable
    public Location location;

    /**
     * The Locations.
     * 
     */
    @SerializedName(value = "locations", alternate = {"Locations"})
    @Expose
	@Nullable
    public java.util.List<Location> locations;

    /**
     * The Online Meeting.
     * 
     */
    @SerializedName(value = "onlineMeeting", alternate = {"OnlineMeeting"})
    @Expose
	@Nullable
    public OnlineMeetingInfo onlineMeeting;

    /**
     * The Online Meeting Provider.
     * 
     */
    @SerializedName(value = "onlineMeetingProvider", alternate = {"OnlineMeetingProvider"})
    @Expose
	@Nullable
    public OnlineMeetingProviderType onlineMeetingProvider;

    /**
     * The Online Meeting Url.
     * 
     */
    @SerializedName(value = "onlineMeetingUrl", alternate = {"OnlineMeetingUrl"})
    @Expose
	@Nullable
    public String onlineMeetingUrl;

    /**
     * The Organizer.
     * 
     */
    @SerializedName(value = "organizer", alternate = {"Organizer"})
    @Expose
	@Nullable
    public Recipient organizer;

    /**
     * The Original End Time Zone.
     * 
     */
    @SerializedName(value = "originalEndTimeZone", alternate = {"OriginalEndTimeZone"})
    @Expose
	@Nullable
    public String originalEndTimeZone;

    /**
     * The Original Start.
     * 
     */
    @SerializedName(value = "originalStart", alternate = {"OriginalStart"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime originalStart;

    /**
     * The Original Start Time Zone.
     * 
     */
    @SerializedName(value = "originalStartTimeZone", alternate = {"OriginalStartTimeZone"})
    @Expose
	@Nullable
    public String originalStartTimeZone;

    /**
     * The Recurrence.
     * 
     */
    @SerializedName(value = "recurrence", alternate = {"Recurrence"})
    @Expose
	@Nullable
    public PatternedRecurrence recurrence;

    /**
     * The Reminder Minutes Before Start.
     * 
     */
    @SerializedName(value = "reminderMinutesBeforeStart", alternate = {"ReminderMinutesBeforeStart"})
    @Expose
	@Nullable
    public Integer reminderMinutesBeforeStart;

    /**
     * The Response Requested.
     * 
     */
    @SerializedName(value = "responseRequested", alternate = {"ResponseRequested"})
    @Expose
	@Nullable
    public Boolean responseRequested;

    /**
     * The Response Status.
     * 
     */
    @SerializedName(value = "responseStatus", alternate = {"ResponseStatus"})
    @Expose
	@Nullable
    public ResponseStatus responseStatus;

    /**
     * The Sensitivity.
     * 
     */
    @SerializedName(value = "sensitivity", alternate = {"Sensitivity"})
    @Expose
	@Nullable
    public Sensitivity sensitivity;

    /**
     * The Series Master Id.
     * 
     */
    @SerializedName(value = "seriesMasterId", alternate = {"SeriesMasterId"})
    @Expose
	@Nullable
    public String seriesMasterId;

    /**
     * The Show As.
     * 
     */
    @SerializedName(value = "showAs", alternate = {"ShowAs"})
    @Expose
	@Nullable
    public FreeBusyStatus showAs;

    /**
     * The Start.
     * 
     */
    @SerializedName(value = "start", alternate = {"Start"})
    @Expose
	@Nullable
    public DateTimeTimeZone start;

    /**
     * The Subject.
     * 
     */
    @SerializedName(value = "subject", alternate = {"Subject"})
    @Expose
	@Nullable
    public String subject;

    /**
     * The Transaction Id.
     * 
     */
    @SerializedName(value = "transactionId", alternate = {"TransactionId"})
    @Expose
	@Nullable
    public String transactionId;

    /**
     * The Type.
     * 
     */
    @SerializedName(value = "type", alternate = {"Type"})
    @Expose
	@Nullable
    public EventType type;

    /**
     * The Web Link.
     * 
     */
    @SerializedName(value = "webLink", alternate = {"WebLink"})
    @Expose
	@Nullable
    public String webLink;

    /**
     * The Attachments.
     * The collection of FileAttachment, ItemAttachment, and referenceAttachment attachments for the event. Navigation property. Read-only. Nullable.
     */
    @SerializedName(value = "attachments", alternate = {"Attachments"})
    @Expose
	@Nullable
    public AttachmentCollectionPage attachments;

    /**
     * The Calendar.
     * The calendar that contains the event. Navigation property. Read-only.
     */
    @SerializedName(value = "calendar", alternate = {"Calendar"})
    @Expose
	@Nullable
    public Calendar calendar;

    /**
     * The Extensions.
     * The collection of open extensions defined for the event. Nullable.
     */
    @SerializedName(value = "extensions", alternate = {"Extensions"})
    @Expose
	@Nullable
    public ExtensionCollectionPage extensions;

    /**
     * The Instances.
     * The occurrences of a recurring series, if the event is a series master. This property includes occurrences that are part of the recurrence pattern, and exceptions that have been modified, but does not include occurrences that have been cancelled from the series. Navigation property. Read-only. Nullable.
     */
    @SerializedName(value = "instances", alternate = {"Instances"})
    @Expose
	@Nullable
    public EventCollectionPage instances;

    /**
     * The Multi Value Extended Properties.
     * The collection of multi-value extended properties defined for the event. Read-only. Nullable.
     */
    @SerializedName(value = "multiValueExtendedProperties", alternate = {"MultiValueExtendedProperties"})
    @Expose
	@Nullable
    public MultiValueLegacyExtendedPropertyCollectionPage multiValueExtendedProperties;

    /**
     * The Single Value Extended Properties.
     * The collection of single-value extended properties defined for the event. Read-only. Nullable.
     */
    @SerializedName(value = "singleValueExtendedProperties", alternate = {"SingleValueExtendedProperties"})
    @Expose
	@Nullable
    public SingleValueLegacyExtendedPropertyCollectionPage singleValueExtendedProperties;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("attachments")) {
            attachments = serializer.deserializeObject(json.get("attachments"), AttachmentCollectionPage.class);
        }

        if (json.has("extensions")) {
            extensions = serializer.deserializeObject(json.get("extensions"), ExtensionCollectionPage.class);
        }

        if (json.has("instances")) {
            instances = serializer.deserializeObject(json.get("instances"), EventCollectionPage.class);
        }

        if (json.has("multiValueExtendedProperties")) {
            multiValueExtendedProperties = serializer.deserializeObject(json.get("multiValueExtendedProperties"), MultiValueLegacyExtendedPropertyCollectionPage.class);
        }

        if (json.has("singleValueExtendedProperties")) {
            singleValueExtendedProperties = serializer.deserializeObject(json.get("singleValueExtendedProperties"), SingleValueLegacyExtendedPropertyCollectionPage.class);
        }
    }
}
