// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.termstore.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.termstore.models.RelationType;
import com.microsoft.graph.termstore.models.Term;
import com.microsoft.graph.termstore.models.Set;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Relation.
 */
public class Relation extends Entity implements IJsonBackedObject {


    /**
     * The Relationship.
     * The type of relation. Possible values are: pin, reuse.
     */
    @SerializedName(value = "relationship", alternate = {"Relationship"})
    @Expose
	@Nullable
    public RelationType relationship;

    /**
     * The From Term.
     * The from [term] of the relation. The term from which the relationship is defined. A null value would indicate the relation is directly with the [set].
     */
    @SerializedName(value = "fromTerm", alternate = {"FromTerm"})
    @Expose
	@Nullable
    public Term fromTerm;

    /**
     * The Set.
     * The [set] in which the relation is relevant.
     */
    @SerializedName(value = "set", alternate = {"Set"})
    @Expose
	@Nullable
    public Set set;

    /**
     * The To Term.
     * The to [term] of the relation. The term to which the relationship is defined.
     */
    @SerializedName(value = "toTerm", alternate = {"ToTerm"})
    @Expose
	@Nullable
    public Term toTerm;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
