// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.SharingDetail;
import com.microsoft.graph.models.ResourceReference;
import com.microsoft.graph.models.ResourceVisualization;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Shared Insight.
 */
public class SharedInsight extends Entity implements IJsonBackedObject {


    /**
     * The Last Shared.
     * Details about the shared item. Read only.
     */
    @SerializedName(value = "lastShared", alternate = {"LastShared"})
    @Expose
	@Nullable
    public SharingDetail lastShared;

    /**
     * The Resource Reference.
     * Reference properties of the shared document, such as the url and type of the document. Read-only
     */
    @SerializedName(value = "resourceReference", alternate = {"ResourceReference"})
    @Expose
	@Nullable
    public ResourceReference resourceReference;

    /**
     * The Resource Visualization.
     * Properties that you can use to visualize the document in your experience. Read-only
     */
    @SerializedName(value = "resourceVisualization", alternate = {"ResourceVisualization"})
    @Expose
	@Nullable
    public ResourceVisualization resourceVisualization;

    /**
     * The Sharing History.
     * 
     */
    @SerializedName(value = "sharingHistory", alternate = {"SharingHistory"})
    @Expose
	@Nullable
    public java.util.List<SharingDetail> sharingHistory;

    /**
     * The Last Shared Method.
     * 
     */
    @SerializedName(value = "lastSharedMethod", alternate = {"LastSharedMethod"})
    @Expose
	@Nullable
    public Entity lastSharedMethod;

    /**
     * The Resource.
     * Used for navigating to the item that was shared. For file attachments, the type is fileAttachment. For linked attachments, the type is driveItem.
     */
    @SerializedName(value = "resource", alternate = {"Resource"})
    @Expose
	@Nullable
    public Entity resource;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
