// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.UserIdentity;
import com.microsoft.graph.models.PrintJobProcessingState;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Archived Print Job.
 */
public class ArchivedPrintJob implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Acquired By Printer.
     * True if the job was acquired by a printer; false otherwise. Read-only.
     */
    @SerializedName(value = "acquiredByPrinter", alternate = {"AcquiredByPrinter"})
    @Expose
	@Nullable
    public Boolean acquiredByPrinter;

    /**
     * The Acquired Date Time.
     * The dateTimeOffset when the job was acquired by the printer, if any. Read-only.
     */
    @SerializedName(value = "acquiredDateTime", alternate = {"AcquiredDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime acquiredDateTime;

    /**
     * The Completion Date Time.
     * The dateTimeOffset when the job was completed, canceled or aborted. Read-only.
     */
    @SerializedName(value = "completionDateTime", alternate = {"CompletionDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime completionDateTime;

    /**
     * The Copies Printed.
     * The number of copies that were printed. Read-only.
     */
    @SerializedName(value = "copiesPrinted", alternate = {"CopiesPrinted"})
    @Expose
	@Nullable
    public Integer copiesPrinted;

    /**
     * The Created By.
     * The user who created the print job. Read-only.
     */
    @SerializedName(value = "createdBy", alternate = {"CreatedBy"})
    @Expose
	@Nullable
    public UserIdentity createdBy;

    /**
     * The Created Date Time.
     * The dateTimeOffset when the job was created. Read-only.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Id.
     * The archived print job's GUID. Read-only.
     */
    @SerializedName(value = "id", alternate = {"Id"})
    @Expose
	@Nullable
    public String id;

    /**
     * The Printer Id.
     * The printer ID that the job was queued for. Read-only.
     */
    @SerializedName(value = "printerId", alternate = {"PrinterId"})
    @Expose
	@Nullable
    public String printerId;

    /**
     * The Processing State.
     * The print job's final processing state. Read-only.
     */
    @SerializedName(value = "processingState", alternate = {"ProcessingState"})
    @Expose
	@Nullable
    public PrintJobProcessingState processingState;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
