// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.callrecords.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Direct Routing Log Row.
 */
public class DirectRoutingLogRow implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Callee Number.
     * 
     */
    @SerializedName(value = "calleeNumber", alternate = {"CalleeNumber"})
    @Expose
	@Nullable
    public String calleeNumber;

    /**
     * The Call End Sub Reason.
     * 
     */
    @SerializedName(value = "callEndSubReason", alternate = {"CallEndSubReason"})
    @Expose
	@Nullable
    public Integer callEndSubReason;

    /**
     * The Caller Number.
     * 
     */
    @SerializedName(value = "callerNumber", alternate = {"CallerNumber"})
    @Expose
	@Nullable
    public String callerNumber;

    /**
     * The Call Type.
     * 
     */
    @SerializedName(value = "callType", alternate = {"CallType"})
    @Expose
	@Nullable
    public String callType;

    /**
     * The Correlation Id.
     * 
     */
    @SerializedName(value = "correlationId", alternate = {"CorrelationId"})
    @Expose
	@Nullable
    public String correlationId;

    /**
     * The Duration.
     * 
     */
    @SerializedName(value = "duration", alternate = {"Duration"})
    @Expose
	@Nullable
    public Integer duration;

    /**
     * The End Date Time.
     * 
     */
    @SerializedName(value = "endDateTime", alternate = {"EndDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime endDateTime;

    /**
     * The Failure Date Time.
     * 
     */
    @SerializedName(value = "failureDateTime", alternate = {"FailureDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime failureDateTime;

    /**
     * The Final Sip Code.
     * 
     */
    @SerializedName(value = "finalSipCode", alternate = {"FinalSipCode"})
    @Expose
	@Nullable
    public Integer finalSipCode;

    /**
     * The Final Sip Code Phrase.
     * 
     */
    @SerializedName(value = "finalSipCodePhrase", alternate = {"FinalSipCodePhrase"})
    @Expose
	@Nullable
    public String finalSipCodePhrase;

    /**
     * The Id.
     * 
     */
    @SerializedName(value = "id", alternate = {"Id"})
    @Expose
	@Nullable
    public String id;

    /**
     * The Invite Date Time.
     * 
     */
    @SerializedName(value = "inviteDateTime", alternate = {"InviteDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime inviteDateTime;

    /**
     * The Media Bypass Enabled.
     * 
     */
    @SerializedName(value = "mediaBypassEnabled", alternate = {"MediaBypassEnabled"})
    @Expose
	@Nullable
    public Boolean mediaBypassEnabled;

    /**
     * The Media Path Location.
     * 
     */
    @SerializedName(value = "mediaPathLocation", alternate = {"MediaPathLocation"})
    @Expose
	@Nullable
    public String mediaPathLocation;

    /**
     * The Signaling Location.
     * 
     */
    @SerializedName(value = "signalingLocation", alternate = {"SignalingLocation"})
    @Expose
	@Nullable
    public String signalingLocation;

    /**
     * The Start Date Time.
     * 
     */
    @SerializedName(value = "startDateTime", alternate = {"StartDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime startDateTime;

    /**
     * The Successful Call.
     * 
     */
    @SerializedName(value = "successfulCall", alternate = {"SuccessfulCall"})
    @Expose
	@Nullable
    public Boolean successfulCall;

    /**
     * The Trunk Fully Qualified Domain Name.
     * 
     */
    @SerializedName(value = "trunkFullyQualifiedDomainName", alternate = {"TrunkFullyQualifiedDomainName"})
    @Expose
	@Nullable
    public String trunkFullyQualifiedDomainName;

    /**
     * The User Display Name.
     * 
     */
    @SerializedName(value = "userDisplayName", alternate = {"UserDisplayName"})
    @Expose
	@Nullable
    public String userDisplayName;

    /**
     * The User Id.
     * 
     */
    @SerializedName(value = "userId", alternate = {"UserId"})
    @Expose
	@Nullable
    public String userId;

    /**
     * The User Principal Name.
     * 
     */
    @SerializedName(value = "userPrincipalName", alternate = {"UserPrincipalName"})
    @Expose
	@Nullable
    public String userPrincipalName;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
