// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.AccessReviewScope;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Principal Resource Memberships Scope.
 */
public class PrincipalResourceMembershipsScope extends AccessReviewScope implements IJsonBackedObject {


    /**
     * The Principal Scopes.
     * Defines the scopes of the principals to be included in an access review.
     */
    @SerializedName(value = "principalScopes", alternate = {"PrincipalScopes"})
    @Expose
	@Nullable
    public java.util.List<AccessReviewScope> principalScopes;

    /**
     * The Resource Scopes.
     * Defines the scopes of the resources for which access will be reviewed.
     */
    @SerializedName(value = "resourceScopes", alternate = {"ResourceScopes"})
    @Expose
	@Nullable
    public java.util.List<AccessReviewScope> resourceScopes;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
