/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.models.Directory;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.AdministrativeUnitCollectionRequestBuilder;
import com.microsoft.graph.requests.AdministrativeUnitRequestBuilder;
import com.microsoft.graph.requests.ApplicationCollectionRequestBuilder;
import com.microsoft.graph.requests.ApplicationRequestBuilder;
import com.microsoft.graph.requests.DirectoryObjectCollectionRequestBuilder;
import com.microsoft.graph.requests.DirectoryObjectRequestBuilder;
import com.microsoft.graph.requests.DirectoryRequest;
import com.microsoft.graph.requests.GroupCollectionRequestBuilder;
import com.microsoft.graph.requests.GroupRequestBuilder;
import com.microsoft.graph.requests.UserCollectionRequestBuilder;
import com.microsoft.graph.requests.UserRequestBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DirectoryRequestBuilder
extends BaseRequestBuilder<Directory> {
    public DirectoryRequestBuilder(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    @Nonnull
    public DirectoryRequest buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Nonnull
    public DirectoryRequest buildRequest(@Nonnull List<? extends Option> requestOptions) {
        return new DirectoryRequest(this.getRequestUrl(), this.getClient(), requestOptions);
    }

    @Nonnull
    public AdministrativeUnitCollectionRequestBuilder administrativeUnits() {
        return new AdministrativeUnitCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("administrativeUnits"), this.getClient(), null);
    }

    @Nonnull
    public AdministrativeUnitRequestBuilder administrativeUnits(@Nonnull String id) {
        return new AdministrativeUnitRequestBuilder(this.getRequestUrlWithAdditionalSegment("administrativeUnits") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public DirectoryObjectCollectionRequestBuilder deletedItems() {
        return new DirectoryObjectCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("deletedItems"), this.getClient(), null);
    }

    @Nonnull
    public DirectoryObjectRequestBuilder deletedItems(@Nonnull String id) {
        return new DirectoryObjectRequestBuilder(this.getRequestUrlWithAdditionalSegment("deletedItems") + "/" + id, this.getClient(), null);
    }

    @Nonnull
    public UserCollectionRequestBuilder deletedItemsAsUser() {
        return new UserCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("deletedItems") + "/microsoft.graph.user", this.getClient(), null);
    }

    @Nonnull
    public UserRequestBuilder deletedItemsAsUser(@Nonnull String id) {
        return new UserRequestBuilder(this.getRequestUrlWithAdditionalSegment("deletedItems") + "/" + id + "/microsoft.graph.user", this.getClient(), null);
    }

    @Nonnull
    public GroupCollectionRequestBuilder deletedItemsAsGroup() {
        return new GroupCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("deletedItems") + "/microsoft.graph.group", this.getClient(), null);
    }

    @Nonnull
    public GroupRequestBuilder deletedItemsAsGroup(@Nonnull String id) {
        return new GroupRequestBuilder(this.getRequestUrlWithAdditionalSegment("deletedItems") + "/" + id + "/microsoft.graph.group", this.getClient(), null);
    }

    @Nonnull
    public ApplicationCollectionRequestBuilder deletedItemsAsApplication() {
        return new ApplicationCollectionRequestBuilder(this.getRequestUrlWithAdditionalSegment("deletedItems") + "/microsoft.graph.application", this.getClient(), null);
    }

    @Nonnull
    public ApplicationRequestBuilder deletedItemsAsApplication(@Nonnull String id) {
        return new ApplicationRequestBuilder(this.getRequestUrlWithAdditionalSegment("deletedItems") + "/" + id + "/microsoft.graph.application", this.getClient(), null);
    }
}

