// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AccessReviewInstanceFilterByCurrentUserOptions;
import com.microsoft.graph.models.AccessReviewInstance;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.AccessReviewInstanceFilterByCurrentUserCollectionRequestBuilder;
import com.microsoft.graph.requests.AccessReviewInstanceFilterByCurrentUserCollectionRequest;
import com.microsoft.graph.requests.AccessReviewInstanceFilterByCurrentUserCollectionResponse;
import com.microsoft.graph.models.AccessReviewInstanceFilterByCurrentUserParameterSet;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Review Instance Filter By Current User Collection Request Builder.
 */
public class AccessReviewInstanceFilterByCurrentUserCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<AccessReviewInstance, AccessReviewInstanceFilterByCurrentUserCollectionRequestBuilder, AccessReviewInstanceFilterByCurrentUserCollectionResponse, AccessReviewInstanceFilterByCurrentUserCollectionPage, AccessReviewInstanceFilterByCurrentUserCollectionRequest> {

    /**
     * The request builder for this collection of AccessReviewInstance
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AccessReviewInstanceFilterByCurrentUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AccessReviewInstanceFilterByCurrentUserCollectionRequestBuilder.class, AccessReviewInstanceFilterByCurrentUserCollectionRequest.class);
    }
    /**
     * The request builder for this collection of AccessReviewInstance
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public AccessReviewInstanceFilterByCurrentUserCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final AccessReviewInstanceFilterByCurrentUserParameterSet parameters) {
        super(requestUrl, client, requestOptions, AccessReviewInstanceFilterByCurrentUserCollectionRequestBuilder.class, AccessReviewInstanceFilterByCurrentUserCollectionRequest.class);
        if(parameters != null) {
            functionOptions = parameters.getFunctionOptions();
        }
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the AccessReviewInstanceFilterByCurrentUserCollectionRequest instance
     */
    @Override
    @Nonnull
    public AccessReviewInstanceFilterByCurrentUserCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final AccessReviewInstanceFilterByCurrentUserCollectionRequest request = super.buildRequest(requestOptions);
          for (com.microsoft.graph.options.FunctionOption option : functionOptions) {
            request.addFunctionOption(option);
      }
        return request;
    }
}
