// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Chart Set Position Parameter Set.
 */
public class WorkbookChartSetPositionParameterSet {
    /**
     * The start Cell.
     * 
     */
    @SerializedName(value = "startCell", alternate = {"StartCell"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement startCell;

    /**
     * The end Cell.
     * 
     */
    @SerializedName(value = "endCell", alternate = {"EndCell"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement endCell;


    /**
     * Instiaciates a new WorkbookChartSetPositionParameterSet
     */
    public WorkbookChartSetPositionParameterSet() {}
    /**
     * Instiaciates a new WorkbookChartSetPositionParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookChartSetPositionParameterSet(@Nonnull final WorkbookChartSetPositionParameterSetBuilder builder) {
        this.startCell = builder.startCell;
        this.endCell = builder.endCell;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookChartSetPositionParameterSetBuilder newBuilder() {
        return new WorkbookChartSetPositionParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookChartSetPositionParameterSet
     */
    public static final class WorkbookChartSetPositionParameterSetBuilder {
        /**
         * The startCell parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement startCell;
        /**
         * Sets the StartCell
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookChartSetPositionParameterSetBuilder withStartCell(@Nullable final com.google.gson.JsonElement val) {
            this.startCell = val;
            return this;
        }
        /**
         * The endCell parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement endCell;
        /**
         * Sets the EndCell
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookChartSetPositionParameterSetBuilder withEndCell(@Nullable final com.google.gson.JsonElement val) {
            this.endCell = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookChartSetPositionParameterSetBuilder
         */
        @Nullable
        protected WorkbookChartSetPositionParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookChartSetPositionParameterSet build() {
            return new WorkbookChartSetPositionParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.startCell != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("startCell", startCell));
        }
        if(this.endCell != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("endCell", endCell));
        }
        return result;
    }
}
