// Template Source: BaseMethodCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ArchivedPrintJob;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.requests.ReportRootGetGroupArchivedPrintJobsCollectionRequestBuilder;
import com.microsoft.graph.requests.ReportRootGetGroupArchivedPrintJobsCollectionRequest;
import com.microsoft.graph.requests.ReportRootGetGroupArchivedPrintJobsCollectionResponse;
import com.microsoft.graph.models.ReportRootGetGroupArchivedPrintJobsParameterSet;
import com.microsoft.graph.options.FunctionOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseFunctionCollectionRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Report Root Get Group Archived Print Jobs Collection Request Builder.
 */
public class ReportRootGetGroupArchivedPrintJobsCollectionRequestBuilder extends BaseFunctionCollectionRequestBuilder<ArchivedPrintJob, ReportRootGetGroupArchivedPrintJobsCollectionRequestBuilder, ReportRootGetGroupArchivedPrintJobsCollectionResponse, ReportRootGetGroupArchivedPrintJobsCollectionPage, ReportRootGetGroupArchivedPrintJobsCollectionRequest> {

    /**
     * The request builder for this collection of ReportRoot
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ReportRootGetGroupArchivedPrintJobsCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ReportRootGetGroupArchivedPrintJobsCollectionRequestBuilder.class, ReportRootGetGroupArchivedPrintJobsCollectionRequest.class);
    }
    /**
     * The request builder for this collection of ReportRoot
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public ReportRootGetGroupArchivedPrintJobsCollectionRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final ReportRootGetGroupArchivedPrintJobsParameterSet parameters) {
        super(requestUrl, client, requestOptions, ReportRootGetGroupArchivedPrintJobsCollectionRequestBuilder.class, ReportRootGetGroupArchivedPrintJobsCollectionRequest.class);
        if(parameters != null) {
            functionOptions = parameters.getFunctionOptions();
        }
    }
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the ReportRootGetGroupArchivedPrintJobsCollectionRequest instance
     */
    @Override
    @Nonnull
    public ReportRootGetGroupArchivedPrintJobsCollectionRequest buildRequest(@Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final ReportRootGetGroupArchivedPrintJobsCollectionRequest request = super.buildRequest(requestOptions);
          for (com.microsoft.graph.options.FunctionOption option : functionOptions) {
            request.addFunctionOption(option);
      }
        return request;
    }
}
