// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.DeviceEnrollmentType;
import com.microsoft.graph.models.DeviceEnrollmentFailureReason;
import com.microsoft.graph.models.DeviceManagementTroubleshootingEvent;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Enrollment Troubleshooting Event.
 */
public class EnrollmentTroubleshootingEvent extends DeviceManagementTroubleshootingEvent implements IJsonBackedObject {


    /**
     * The Device Id.
     * Azure AD device identifier.
     */
    @SerializedName(value = "deviceId", alternate = {"DeviceId"})
    @Expose
	@Nullable
    public String deviceId;

    /**
     * The Enrollment Type.
     * Type of the enrollment. Possible values are: unknown, userEnrollment, deviceEnrollmentManager, appleBulkWithUser, appleBulkWithoutUser, windowsAzureADJoin, windowsBulkUserless, windowsAutoEnrollment, windowsBulkAzureDomainJoin, windowsCoManagement.
     */
    @SerializedName(value = "enrollmentType", alternate = {"EnrollmentType"})
    @Expose
	@Nullable
    public DeviceEnrollmentType enrollmentType;

    /**
     * The Failure Category.
     * Highlevel failure category. Possible values are: unknown, authentication, authorization, accountValidation, userValidation, deviceNotSupported, inMaintenance, badRequest, featureNotSupported, enrollmentRestrictionsEnforced, clientDisconnected, userAbandonment.
     */
    @SerializedName(value = "failureCategory", alternate = {"FailureCategory"})
    @Expose
	@Nullable
    public DeviceEnrollmentFailureReason failureCategory;

    /**
     * The Failure Reason.
     * Detailed failure reason.
     */
    @SerializedName(value = "failureReason", alternate = {"FailureReason"})
    @Expose
	@Nullable
    public String failureReason;

    /**
     * The Managed Device Identifier.
     * Device identifier created or collected by Intune.
     */
    @SerializedName(value = "managedDeviceIdentifier", alternate = {"ManagedDeviceIdentifier"})
    @Expose
	@Nullable
    public String managedDeviceIdentifier;

    /**
     * The Operating System.
     * Operating System.
     */
    @SerializedName(value = "operatingSystem", alternate = {"OperatingSystem"})
    @Expose
	@Nullable
    public String operatingSystem;

    /**
     * The Os Version.
     * OS Version.
     */
    @SerializedName(value = "osVersion", alternate = {"OsVersion"})
    @Expose
	@Nullable
    public String osVersion;

    /**
     * The User Id.
     * Identifier for the user that tried to enroll the device.
     */
    @SerializedName(value = "userId", alternate = {"UserId"})
    @Expose
	@Nullable
    public String userId;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
