// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.OnenoteOperationError;
import com.microsoft.graph.models.Operation;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Onenote Operation.
 */
public class OnenoteOperation extends Operation implements IJsonBackedObject {


    /**
     * The Error.
     * The error returned by the operation.
     */
    @SerializedName(value = "error", alternate = {"Error"})
    @Expose
	@Nullable
    public OnenoteOperationError error;

    /**
     * The Percent Complete.
     * The operation percent complete if the operation is still in running status
     */
    @SerializedName(value = "percentComplete", alternate = {"PercentComplete"})
    @Expose
	@Nullable
    public String percentComplete;

    /**
     * The Resource Id.
     * The resource id.
     */
    @SerializedName(value = "resourceId", alternate = {"ResourceId"})
    @Expose
	@Nullable
    public String resourceId;

    /**
     * The Resource Location.
     * The resource URI for the object. For example, the resource URI for a copied page or section.
     */
    @SerializedName(value = "resourceLocation", alternate = {"ResourceLocation"})
    @Expose
	@Nullable
    public String resourceLocation;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
