/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.RoomList;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IRoomListRequest;
import java.util.List;

public class RoomListRequest
extends BaseRequest
implements IRoomListRequest {
    public RoomListRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, RoomList.class);
    }

    @Override
    public void get(ICallback<? super RoomList> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public RoomList get() throws ClientException {
        return (RoomList)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super RoomList> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(RoomList sourceRoomList, ICallback<? super RoomList> callback) {
        this.send(HttpMethod.PATCH, callback, sourceRoomList);
    }

    @Override
    public RoomList patch(RoomList sourceRoomList) throws ClientException {
        return (RoomList)this.send(HttpMethod.PATCH, sourceRoomList);
    }

    @Override
    public void post(RoomList newRoomList, ICallback<? super RoomList> callback) {
        this.send(HttpMethod.POST, callback, newRoomList);
    }

    @Override
    public RoomList post(RoomList newRoomList) throws ClientException {
        return (RoomList)this.send(HttpMethod.POST, newRoomList);
    }

    @Override
    public void put(RoomList newRoomList, ICallback<? super RoomList> callback) {
        this.send(HttpMethod.PUT, callback, newRoomList);
    }

    @Override
    public RoomList put(RoomList newRoomList) throws ClientException {
        return (RoomList)this.send(HttpMethod.PUT, newRoomList);
    }

    @Override
    public IRoomListRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IRoomListRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

