/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.EndpointCollectionResponse;
import com.microsoft.graph.requests.extensions.EndpointCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.EndpointCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IEndpointCollectionPage;
import com.microsoft.graph.requests.extensions.IEndpointCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.IEndpointCollectionWithReferencesRequest;
import java.util.List;

public class EndpointCollectionWithReferencesRequest
extends BaseCollectionRequest<EndpointCollectionResponse, IEndpointCollectionPage>
implements IEndpointCollectionWithReferencesRequest {
    public EndpointCollectionWithReferencesRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, EndpointCollectionResponse.class, IEndpointCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IEndpointCollectionWithReferencesPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(EndpointCollectionWithReferencesRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IEndpointCollectionWithReferencesPage get() throws ClientException {
        EndpointCollectionResponse response = (EndpointCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public IEndpointCollectionWithReferencesRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IEndpointCollectionWithReferencesRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IEndpointCollectionWithReferencesRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IEndpointCollectionWithReferencesRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IEndpointCollectionWithReferencesRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public IEndpointCollectionWithReferencesPage buildFromResponse(EndpointCollectionResponse response) {
        EndpointCollectionWithReferencesRequestBuilder builder = response.nextLink != null ? new EndpointCollectionWithReferencesRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        EndpointCollectionWithReferencesPage page = new EndpointCollectionWithReferencesPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

