/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.http.ReferenceRequestBody;
import com.microsoft.graph.models.extensions.TokenIssuancePolicy;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITokenIssuancePolicyCollectionPage;
import com.microsoft.graph.requests.extensions.ITokenIssuancePolicyCollectionReferenceRequest;
import com.microsoft.graph.requests.extensions.TokenIssuancePolicyCollectionResponse;
import com.microsoft.graph.requests.extensions.TokenIssuancePolicyWithReferenceRequestBuilder;
import java.util.List;

public class TokenIssuancePolicyCollectionReferenceRequest
extends BaseCollectionRequest<TokenIssuancePolicyCollectionResponse, ITokenIssuancePolicyCollectionPage>
implements ITokenIssuancePolicyCollectionReferenceRequest {
    public TokenIssuancePolicyCollectionReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TokenIssuancePolicyCollectionResponse.class, ITokenIssuancePolicyCollectionPage.class);
    }

    @Override
    public void post(TokenIssuancePolicy newTokenIssuancePolicy, ICallback<? super TokenIssuancePolicy> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/policies/tokenIssuancePolicies/" + newTokenIssuancePolicy.id);
        new TokenIssuancePolicyWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTokenIssuancePolicy, body, callback);
    }

    @Override
    public TokenIssuancePolicy post(TokenIssuancePolicy newTokenIssuancePolicy) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/policies/tokenIssuancePolicies/" + newTokenIssuancePolicy.id);
        return new TokenIssuancePolicyWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTokenIssuancePolicy, body);
    }

    public ITokenIssuancePolicyCollectionReferenceRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public ITokenIssuancePolicyCollectionReferenceRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public ITokenIssuancePolicyCollectionReferenceRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public ITokenIssuancePolicyCollectionReferenceRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITokenIssuancePolicyCollectionReferenceRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }
}

