/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.IdentityContainer;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IIdentityContainerRequest;
import java.util.List;

public class IdentityContainerRequest
extends BaseRequest
implements IIdentityContainerRequest {
    public IdentityContainerRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, IdentityContainer.class);
    }

    @Override
    public void get(ICallback<? super IdentityContainer> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public IdentityContainer get() throws ClientException {
        return (IdentityContainer)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super IdentityContainer> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(IdentityContainer sourceIdentityContainer, ICallback<? super IdentityContainer> callback) {
        this.send(HttpMethod.PATCH, callback, sourceIdentityContainer);
    }

    @Override
    public IdentityContainer patch(IdentityContainer sourceIdentityContainer) throws ClientException {
        return (IdentityContainer)this.send(HttpMethod.PATCH, sourceIdentityContainer);
    }

    @Override
    public void post(IdentityContainer newIdentityContainer, ICallback<? super IdentityContainer> callback) {
        this.send(HttpMethod.POST, callback, newIdentityContainer);
    }

    @Override
    public IdentityContainer post(IdentityContainer newIdentityContainer) throws ClientException {
        return (IdentityContainer)this.send(HttpMethod.POST, newIdentityContainer);
    }

    @Override
    public void put(IdentityContainer newIdentityContainer, ICallback<? super IdentityContainer> callback) {
        this.send(HttpMethod.PUT, callback, newIdentityContainer);
    }

    @Override
    public IdentityContainer put(IdentityContainer newIdentityContainer) throws ClientException {
        return (IdentityContainer)this.send(HttpMethod.PUT, newIdentityContainer);
    }

    @Override
    public IIdentityContainerRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IIdentityContainerRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

