/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.SearchEntityQueryBody;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISearchEntityQueryCollectionPage;
import com.microsoft.graph.requests.extensions.ISearchEntityQueryCollectionRequest;
import com.microsoft.graph.requests.extensions.SearchEntityQueryCollectionPage;
import com.microsoft.graph.requests.extensions.SearchEntityQueryCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.SearchEntityQueryCollectionResponse;
import java.util.List;

public class SearchEntityQueryCollectionRequest
extends BaseCollectionRequest<SearchEntityQueryCollectionResponse, ISearchEntityQueryCollectionPage>
implements ISearchEntityQueryCollectionRequest {
    protected final SearchEntityQueryBody body = new SearchEntityQueryBody();

    public SearchEntityQueryCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SearchEntityQueryCollectionResponse.class, ISearchEntityQueryCollectionPage.class);
    }

    @Override
    public void post(final ICallback<? super ISearchEntityQueryCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(SearchEntityQueryCollectionRequest.this.post(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISearchEntityQueryCollectionPage post() throws ClientException {
        SearchEntityQueryCollectionResponse response = (SearchEntityQueryCollectionResponse)this.post(this.body);
        return this.buildFromResponse(response);
    }

    public ISearchEntityQueryCollectionPage buildFromResponse(SearchEntityQueryCollectionResponse response) {
        SearchEntityQueryCollectionRequestBuilder builder = response.nextLink != null ? new SearchEntityQueryCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null, null) : null;
        SearchEntityQueryCollectionPage page = new SearchEntityQueryCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public ISearchEntityQueryCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISearchEntityQueryCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ISearchEntityQueryCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public ISearchEntityQueryCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public ISearchEntityQueryCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }
}

