// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.ResourceSpecificPermissionGrant;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Resource Specific Permission Grant Request.
 */
public class ResourceSpecificPermissionGrantRequest extends BaseRequest implements IResourceSpecificPermissionGrantRequest {
	
    /**
     * The request for the ResourceSpecificPermissionGrant
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ResourceSpecificPermissionGrantRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ResourceSpecificPermissionGrant.class);
    }

    /**
     * Gets the ResourceSpecificPermissionGrant from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super ResourceSpecificPermissionGrant> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the ResourceSpecificPermissionGrant from the service
     *
     * @return the ResourceSpecificPermissionGrant from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ResourceSpecificPermissionGrant get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super ResourceSpecificPermissionGrant> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ResourceSpecificPermissionGrant with a source
     *
     * @param sourceResourceSpecificPermissionGrant the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final ResourceSpecificPermissionGrant sourceResourceSpecificPermissionGrant, final ICallback<? super ResourceSpecificPermissionGrant> callback) {
        send(HttpMethod.PATCH, callback, sourceResourceSpecificPermissionGrant);
    }

    /**
     * Patches this ResourceSpecificPermissionGrant with a source
     *
     * @param sourceResourceSpecificPermissionGrant the source object with updates
     * @return the updated ResourceSpecificPermissionGrant
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ResourceSpecificPermissionGrant patch(final ResourceSpecificPermissionGrant sourceResourceSpecificPermissionGrant) throws ClientException {
        return send(HttpMethod.PATCH, sourceResourceSpecificPermissionGrant);
    }

    /**
     * Creates a ResourceSpecificPermissionGrant with a new object
     *
     * @param newResourceSpecificPermissionGrant the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final ResourceSpecificPermissionGrant newResourceSpecificPermissionGrant, final ICallback<? super ResourceSpecificPermissionGrant> callback) {
        send(HttpMethod.POST, callback, newResourceSpecificPermissionGrant);
    }

    /**
     * Creates a ResourceSpecificPermissionGrant with a new object
     *
     * @param newResourceSpecificPermissionGrant the new object to create
     * @return the created ResourceSpecificPermissionGrant
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ResourceSpecificPermissionGrant post(final ResourceSpecificPermissionGrant newResourceSpecificPermissionGrant) throws ClientException {
        return send(HttpMethod.POST, newResourceSpecificPermissionGrant);
    }

    /**
     * Creates a ResourceSpecificPermissionGrant with a new object
     *
     * @param newResourceSpecificPermissionGrant the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final ResourceSpecificPermissionGrant newResourceSpecificPermissionGrant, final ICallback<? super ResourceSpecificPermissionGrant> callback) {
        send(HttpMethod.PUT, callback, newResourceSpecificPermissionGrant);
    }

    /**
     * Creates a ResourceSpecificPermissionGrant with a new object
     *
     * @param newResourceSpecificPermissionGrant the object to create/update
     * @return the created ResourceSpecificPermissionGrant
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public ResourceSpecificPermissionGrant put(final ResourceSpecificPermissionGrant newResourceSpecificPermissionGrant) throws ClientException {
        return send(HttpMethod.PUT, newResourceSpecificPermissionGrant);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IResourceSpecificPermissionGrantRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (ResourceSpecificPermissionGrantRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IResourceSpecificPermissionGrantRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (ResourceSpecificPermissionGrantRequest)this;
     }

}

