// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.MicrosoftAuthenticatorAuthenticationMethodTarget;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Microsoft Authenticator Authentication Method Target Request.
 */
public interface IMicrosoftAuthenticatorAuthenticationMethodTargetRequest extends IHttpRequest {

    /**
     * Gets the MicrosoftAuthenticatorAuthenticationMethodTarget from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super MicrosoftAuthenticatorAuthenticationMethodTarget> callback);

    /**
     * Gets the MicrosoftAuthenticatorAuthenticationMethodTarget from the service
     *
     * @return the MicrosoftAuthenticatorAuthenticationMethodTarget from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    MicrosoftAuthenticatorAuthenticationMethodTarget get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super MicrosoftAuthenticatorAuthenticationMethodTarget> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this MicrosoftAuthenticatorAuthenticationMethodTarget with a source
     *
     * @param sourceMicrosoftAuthenticatorAuthenticationMethodTarget the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final MicrosoftAuthenticatorAuthenticationMethodTarget sourceMicrosoftAuthenticatorAuthenticationMethodTarget, final ICallback<? super MicrosoftAuthenticatorAuthenticationMethodTarget> callback);

    /**
     * Patches this MicrosoftAuthenticatorAuthenticationMethodTarget with a source
     *
     * @param sourceMicrosoftAuthenticatorAuthenticationMethodTarget the source object with updates
     * @return the updated MicrosoftAuthenticatorAuthenticationMethodTarget
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    MicrosoftAuthenticatorAuthenticationMethodTarget patch(final MicrosoftAuthenticatorAuthenticationMethodTarget sourceMicrosoftAuthenticatorAuthenticationMethodTarget) throws ClientException;

    /**
     * Posts a MicrosoftAuthenticatorAuthenticationMethodTarget with a new object
     *
     * @param newMicrosoftAuthenticatorAuthenticationMethodTarget the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final MicrosoftAuthenticatorAuthenticationMethodTarget newMicrosoftAuthenticatorAuthenticationMethodTarget, final ICallback<? super MicrosoftAuthenticatorAuthenticationMethodTarget> callback);

    /**
     * Posts a MicrosoftAuthenticatorAuthenticationMethodTarget with a new object
     *
     * @param newMicrosoftAuthenticatorAuthenticationMethodTarget the new object to create
     * @return the created MicrosoftAuthenticatorAuthenticationMethodTarget
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    MicrosoftAuthenticatorAuthenticationMethodTarget post(final MicrosoftAuthenticatorAuthenticationMethodTarget newMicrosoftAuthenticatorAuthenticationMethodTarget) throws ClientException;

    /**
     * Posts a MicrosoftAuthenticatorAuthenticationMethodTarget with a new object
     *
     * @param newMicrosoftAuthenticatorAuthenticationMethodTarget the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final MicrosoftAuthenticatorAuthenticationMethodTarget newMicrosoftAuthenticatorAuthenticationMethodTarget, final ICallback<? super MicrosoftAuthenticatorAuthenticationMethodTarget> callback);

    /**
     * Posts a MicrosoftAuthenticatorAuthenticationMethodTarget with a new object
     *
     * @param newMicrosoftAuthenticatorAuthenticationMethodTarget the object to create/update
     * @return the created MicrosoftAuthenticatorAuthenticationMethodTarget
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    MicrosoftAuthenticatorAuthenticationMethodTarget put(final MicrosoftAuthenticatorAuthenticationMethodTarget newMicrosoftAuthenticatorAuthenticationMethodTarget) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IMicrosoftAuthenticatorAuthenticationMethodTargetRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IMicrosoftAuthenticatorAuthenticationMethodTargetRequest expand(final String value);

}

