// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.MicrosoftAuthenticatorAuthenticationMethod;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Microsoft Authenticator Authentication Method Request.
 */
public interface IMicrosoftAuthenticatorAuthenticationMethodRequest extends IHttpRequest {

    /**
     * Gets the MicrosoftAuthenticatorAuthenticationMethod from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super MicrosoftAuthenticatorAuthenticationMethod> callback);

    /**
     * Gets the MicrosoftAuthenticatorAuthenticationMethod from the service
     *
     * @return the MicrosoftAuthenticatorAuthenticationMethod from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    MicrosoftAuthenticatorAuthenticationMethod get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super MicrosoftAuthenticatorAuthenticationMethod> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this MicrosoftAuthenticatorAuthenticationMethod with a source
     *
     * @param sourceMicrosoftAuthenticatorAuthenticationMethod the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final MicrosoftAuthenticatorAuthenticationMethod sourceMicrosoftAuthenticatorAuthenticationMethod, final ICallback<? super MicrosoftAuthenticatorAuthenticationMethod> callback);

    /**
     * Patches this MicrosoftAuthenticatorAuthenticationMethod with a source
     *
     * @param sourceMicrosoftAuthenticatorAuthenticationMethod the source object with updates
     * @return the updated MicrosoftAuthenticatorAuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    MicrosoftAuthenticatorAuthenticationMethod patch(final MicrosoftAuthenticatorAuthenticationMethod sourceMicrosoftAuthenticatorAuthenticationMethod) throws ClientException;

    /**
     * Posts a MicrosoftAuthenticatorAuthenticationMethod with a new object
     *
     * @param newMicrosoftAuthenticatorAuthenticationMethod the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final MicrosoftAuthenticatorAuthenticationMethod newMicrosoftAuthenticatorAuthenticationMethod, final ICallback<? super MicrosoftAuthenticatorAuthenticationMethod> callback);

    /**
     * Posts a MicrosoftAuthenticatorAuthenticationMethod with a new object
     *
     * @param newMicrosoftAuthenticatorAuthenticationMethod the new object to create
     * @return the created MicrosoftAuthenticatorAuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    MicrosoftAuthenticatorAuthenticationMethod post(final MicrosoftAuthenticatorAuthenticationMethod newMicrosoftAuthenticatorAuthenticationMethod) throws ClientException;

    /**
     * Posts a MicrosoftAuthenticatorAuthenticationMethod with a new object
     *
     * @param newMicrosoftAuthenticatorAuthenticationMethod the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final MicrosoftAuthenticatorAuthenticationMethod newMicrosoftAuthenticatorAuthenticationMethod, final ICallback<? super MicrosoftAuthenticatorAuthenticationMethod> callback);

    /**
     * Posts a MicrosoftAuthenticatorAuthenticationMethod with a new object
     *
     * @param newMicrosoftAuthenticatorAuthenticationMethod the object to create/update
     * @return the created MicrosoftAuthenticatorAuthenticationMethod
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    MicrosoftAuthenticatorAuthenticationMethod put(final MicrosoftAuthenticatorAuthenticationMethod newMicrosoftAuthenticatorAuthenticationMethod) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IMicrosoftAuthenticatorAuthenticationMethodRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IMicrosoftAuthenticatorAuthenticationMethodRequest expand(final String value);

}

