// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.MicrosoftAuthenticatorAuthenticationMethodConfiguration;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Microsoft Authenticator Authentication Method Configuration Request.
 */
public interface IMicrosoftAuthenticatorAuthenticationMethodConfigurationRequest extends IHttpRequest {

    /**
     * Gets the MicrosoftAuthenticatorAuthenticationMethodConfiguration from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super MicrosoftAuthenticatorAuthenticationMethodConfiguration> callback);

    /**
     * Gets the MicrosoftAuthenticatorAuthenticationMethodConfiguration from the service
     *
     * @return the MicrosoftAuthenticatorAuthenticationMethodConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    MicrosoftAuthenticatorAuthenticationMethodConfiguration get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super MicrosoftAuthenticatorAuthenticationMethodConfiguration> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this MicrosoftAuthenticatorAuthenticationMethodConfiguration with a source
     *
     * @param sourceMicrosoftAuthenticatorAuthenticationMethodConfiguration the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final MicrosoftAuthenticatorAuthenticationMethodConfiguration sourceMicrosoftAuthenticatorAuthenticationMethodConfiguration, final ICallback<? super MicrosoftAuthenticatorAuthenticationMethodConfiguration> callback);

    /**
     * Patches this MicrosoftAuthenticatorAuthenticationMethodConfiguration with a source
     *
     * @param sourceMicrosoftAuthenticatorAuthenticationMethodConfiguration the source object with updates
     * @return the updated MicrosoftAuthenticatorAuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    MicrosoftAuthenticatorAuthenticationMethodConfiguration patch(final MicrosoftAuthenticatorAuthenticationMethodConfiguration sourceMicrosoftAuthenticatorAuthenticationMethodConfiguration) throws ClientException;

    /**
     * Posts a MicrosoftAuthenticatorAuthenticationMethodConfiguration with a new object
     *
     * @param newMicrosoftAuthenticatorAuthenticationMethodConfiguration the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final MicrosoftAuthenticatorAuthenticationMethodConfiguration newMicrosoftAuthenticatorAuthenticationMethodConfiguration, final ICallback<? super MicrosoftAuthenticatorAuthenticationMethodConfiguration> callback);

    /**
     * Posts a MicrosoftAuthenticatorAuthenticationMethodConfiguration with a new object
     *
     * @param newMicrosoftAuthenticatorAuthenticationMethodConfiguration the new object to create
     * @return the created MicrosoftAuthenticatorAuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    MicrosoftAuthenticatorAuthenticationMethodConfiguration post(final MicrosoftAuthenticatorAuthenticationMethodConfiguration newMicrosoftAuthenticatorAuthenticationMethodConfiguration) throws ClientException;

    /**
     * Posts a MicrosoftAuthenticatorAuthenticationMethodConfiguration with a new object
     *
     * @param newMicrosoftAuthenticatorAuthenticationMethodConfiguration the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final MicrosoftAuthenticatorAuthenticationMethodConfiguration newMicrosoftAuthenticatorAuthenticationMethodConfiguration, final ICallback<? super MicrosoftAuthenticatorAuthenticationMethodConfiguration> callback);

    /**
     * Posts a MicrosoftAuthenticatorAuthenticationMethodConfiguration with a new object
     *
     * @param newMicrosoftAuthenticatorAuthenticationMethodConfiguration the object to create/update
     * @return the created MicrosoftAuthenticatorAuthenticationMethodConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    MicrosoftAuthenticatorAuthenticationMethodConfiguration put(final MicrosoftAuthenticatorAuthenticationMethodConfiguration newMicrosoftAuthenticatorAuthenticationMethodConfiguration) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IMicrosoftAuthenticatorAuthenticationMethodConfigurationRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IMicrosoftAuthenticatorAuthenticationMethodConfigurationRequest expand(final String value);

}

