// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IGroupAddFavoriteRequest;
import com.microsoft.graph.requests.extensions.GroupAddFavoriteRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Group Add Favorite Request Builder.
 */
public class GroupAddFavoriteRequestBuilder extends BaseActionRequestBuilder implements IGroupAddFavoriteRequestBuilder {

    /**
     * The request builder for this GroupAddFavorite
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public GroupAddFavoriteRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the IGroupAddFavoriteRequest
     *
     * @param requestOptions the options for the request
     * @return the IGroupAddFavoriteRequest instance
     */
    public IGroupAddFavoriteRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the IGroupAddFavoriteRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IGroupAddFavoriteRequest instance
     */
    public IGroupAddFavoriteRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        GroupAddFavoriteRequest request = new GroupAddFavoriteRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        return request;
    }
}
