// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.AuthenticationMethodTarget;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authentication Method Target Request.
 */
public class AuthenticationMethodTargetRequest extends BaseRequest implements IAuthenticationMethodTargetRequest {
	
    /**
     * The request for the AuthenticationMethodTarget
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public AuthenticationMethodTargetRequest(final String requestUrl,
            final IBaseClient client,
            final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            final Class<? extends AuthenticationMethodTarget> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the AuthenticationMethodTarget
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AuthenticationMethodTargetRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AuthenticationMethodTarget.class);
    }

    /**
     * Gets the AuthenticationMethodTarget from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super AuthenticationMethodTarget> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the AuthenticationMethodTarget from the service
     *
     * @return the AuthenticationMethodTarget from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AuthenticationMethodTarget get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super AuthenticationMethodTarget> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AuthenticationMethodTarget with a source
     *
     * @param sourceAuthenticationMethodTarget the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final AuthenticationMethodTarget sourceAuthenticationMethodTarget, final ICallback<? super AuthenticationMethodTarget> callback) {
        send(HttpMethod.PATCH, callback, sourceAuthenticationMethodTarget);
    }

    /**
     * Patches this AuthenticationMethodTarget with a source
     *
     * @param sourceAuthenticationMethodTarget the source object with updates
     * @return the updated AuthenticationMethodTarget
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AuthenticationMethodTarget patch(final AuthenticationMethodTarget sourceAuthenticationMethodTarget) throws ClientException {
        return send(HttpMethod.PATCH, sourceAuthenticationMethodTarget);
    }

    /**
     * Creates a AuthenticationMethodTarget with a new object
     *
     * @param newAuthenticationMethodTarget the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final AuthenticationMethodTarget newAuthenticationMethodTarget, final ICallback<? super AuthenticationMethodTarget> callback) {
        send(HttpMethod.POST, callback, newAuthenticationMethodTarget);
    }

    /**
     * Creates a AuthenticationMethodTarget with a new object
     *
     * @param newAuthenticationMethodTarget the new object to create
     * @return the created AuthenticationMethodTarget
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AuthenticationMethodTarget post(final AuthenticationMethodTarget newAuthenticationMethodTarget) throws ClientException {
        return send(HttpMethod.POST, newAuthenticationMethodTarget);
    }

    /**
     * Creates a AuthenticationMethodTarget with a new object
     *
     * @param newAuthenticationMethodTarget the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final AuthenticationMethodTarget newAuthenticationMethodTarget, final ICallback<? super AuthenticationMethodTarget> callback) {
        send(HttpMethod.PUT, callback, newAuthenticationMethodTarget);
    }

    /**
     * Creates a AuthenticationMethodTarget with a new object
     *
     * @param newAuthenticationMethodTarget the object to create/update
     * @return the created AuthenticationMethodTarget
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public AuthenticationMethodTarget put(final AuthenticationMethodTarget newAuthenticationMethodTarget) throws ClientException {
        return send(HttpMethod.PUT, newAuthenticationMethodTarget);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IAuthenticationMethodTargetRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (AuthenticationMethodTargetRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IAuthenticationMethodTargetRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (AuthenticationMethodTargetRequest)this;
     }

}

