// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.Fido2KeyRestrictions;
import com.microsoft.graph.models.extensions.AuthenticationMethodTarget;
import com.microsoft.graph.models.extensions.AuthenticationMethodConfiguration;
import com.microsoft.graph.requests.extensions.AuthenticationMethodTargetCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Fido2Authentication Method Configuration.
 */
public class Fido2AuthenticationMethodConfiguration extends AuthenticationMethodConfiguration implements IJsonBackedObject {


    /**
     * The Is Attestation Enforced.
     * 
     */
    @SerializedName(value = "isAttestationEnforced", alternate = {"IsAttestationEnforced"})
    @Expose
    public Boolean isAttestationEnforced;

    /**
     * The Is Self Service Registration Allowed.
     * 
     */
    @SerializedName(value = "isSelfServiceRegistrationAllowed", alternate = {"IsSelfServiceRegistrationAllowed"})
    @Expose
    public Boolean isSelfServiceRegistrationAllowed;

    /**
     * The Key Restrictions.
     * 
     */
    @SerializedName(value = "keyRestrictions", alternate = {"KeyRestrictions"})
    @Expose
    public Fido2KeyRestrictions keyRestrictions;

    /**
     * The Include Targets.
     * 
     */
    @SerializedName(value = "includeTargets", alternate = {"IncludeTargets"})
    @Expose
    public AuthenticationMethodTargetCollectionPage includeTargets;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;


        if (json.has("includeTargets")) {
            includeTargets = serializer.deserializeObject(json.get("includeTargets").toString(), AuthenticationMethodTargetCollectionPage.class);
        }
    }
}
