// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.DomainState;
import com.microsoft.graph.models.extensions.DirectoryObject;
import com.microsoft.graph.models.extensions.DomainDnsRecord;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.requests.extensions.DirectoryObjectCollectionPage;
import com.microsoft.graph.requests.extensions.DomainDnsRecordCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Domain.
 */
public class Domain extends Entity implements IJsonBackedObject {


    /**
     * The Authentication Type.
     * Indicates the configured authentication type for the domain. The value is either Managed or Federated. Managed indicates a cloud managed domain where Azure AD performs user authentication.Federated indicates authentication is federated with an identity provider such as the tenant's on-premises Active Directory via Active Directory Federation Services. This property is read-only and is not nullable.
     */
    @SerializedName(value = "authenticationType", alternate = {"AuthenticationType"})
    @Expose
    public String authenticationType;

    /**
     * The Availability Status.
     * This property is always null except when the verify action is used. When the verify action is used, a domain entity is returned in the response. The availabilityStatus property of the domain entity in the response is either AvailableImmediately or EmailVerifiedDomainTakeoverScheduled.
     */
    @SerializedName(value = "availabilityStatus", alternate = {"AvailabilityStatus"})
    @Expose
    public String availabilityStatus;

    /**
     * The Is Admin Managed.
     * The value of the property is false if the DNS record management of the domain has been delegated to Microsoft 365. Otherwise, the value is true. Not nullable
     */
    @SerializedName(value = "isAdminManaged", alternate = {"IsAdminManaged"})
    @Expose
    public Boolean isAdminManaged;

    /**
     * The Is Default.
     * True if this is the default domain that is used for user creation. There is only one default domain per company. Not nullable
     */
    @SerializedName(value = "isDefault", alternate = {"IsDefault"})
    @Expose
    public Boolean isDefault;

    /**
     * The Is Initial.
     * True if this is the initial domain created by Microsoft Online Services (companyname.onmicrosoft.com). There is only one initial domain per company. Not nullable
     */
    @SerializedName(value = "isInitial", alternate = {"IsInitial"})
    @Expose
    public Boolean isInitial;

    /**
     * The Is Root.
     * True if the domain is a verified root domain. Otherwise, false if the domain is a subdomain or unverified. Not nullable
     */
    @SerializedName(value = "isRoot", alternate = {"IsRoot"})
    @Expose
    public Boolean isRoot;

    /**
     * The Is Verified.
     * True if the domain has completed domain ownership verification. Not nullable
     */
    @SerializedName(value = "isVerified", alternate = {"IsVerified"})
    @Expose
    public Boolean isVerified;

    /**
     * The Manufacturer.
     * 
     */
    @SerializedName(value = "manufacturer", alternate = {"Manufacturer"})
    @Expose
    public String manufacturer;

    /**
     * The Model.
     * 
     */
    @SerializedName(value = "model", alternate = {"Model"})
    @Expose
    public String model;

    /**
     * The Password Notification Window In Days.
     * Specifies the number of days before a user receives notification that their password will expire. If the property is not set, a default value of 14 days will be used.
     */
    @SerializedName(value = "passwordNotificationWindowInDays", alternate = {"PasswordNotificationWindowInDays"})
    @Expose
    public Integer passwordNotificationWindowInDays;

    /**
     * The Password Validity Period In Days.
     * Specifies the length of time that a password is valid before it must be changed. If the property is not set, a default value of 90 days will be used.
     */
    @SerializedName(value = "passwordValidityPeriodInDays", alternate = {"PasswordValidityPeriodInDays"})
    @Expose
    public Integer passwordValidityPeriodInDays;

    /**
     * The State.
     * Status of asynchronous operations scheduled for the domain.
     */
    @SerializedName(value = "state", alternate = {"State"})
    @Expose
    public DomainState state;

    /**
     * The Supported Services.
     * The capabilities assigned to the domain.Can include 0, 1 or more of following values: Email, Sharepoint, EmailInternalRelayOnly, OfficeCommunicationsOnline, SharePointDefaultDomain, FullRedelegation, SharePointPublic, OrgIdAuthentication, Yammer, Intune The values which you can add/remove using Graph API include: Email, OfficeCommunicationsOnline, YammerNot nullable
     */
    @SerializedName(value = "supportedServices", alternate = {"SupportedServices"})
    @Expose
    public java.util.List<String> supportedServices;

    /**
     * The Domain Name References.
     * Read-only, Nullable
     */
    public DirectoryObjectCollectionPage domainNameReferences;

    /**
     * The Service Configuration Records.
     * DNS records the customer adds to the DNS zone file of the domain before the domain can be used by Microsoft Online services.Read-only, Nullable
     */
    @SerializedName(value = "serviceConfigurationRecords", alternate = {"ServiceConfigurationRecords"})
    @Expose
    public DomainDnsRecordCollectionPage serviceConfigurationRecords;

    /**
     * The Verification Dns Records.
     * DNS records that the customer adds to the DNS zone file of the domain before the customer can complete domain ownership verification with Azure AD.Read-only, Nullable
     */
    @SerializedName(value = "verificationDnsRecords", alternate = {"VerificationDnsRecords"})
    @Expose
    public DomainDnsRecordCollectionPage verificationDnsRecords;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;


        if (json.has("domainNameReferences")) {
            domainNameReferences = serializer.deserializeObject(json.get("domainNameReferences").toString(), DirectoryObjectCollectionPage.class);
        }

        if (json.has("serviceConfigurationRecords")) {
            serviceConfigurationRecords = serializer.deserializeObject(json.get("serviceConfigurationRecords").toString(), DomainDnsRecordCollectionPage.class);
        }

        if (json.has("verificationDnsRecords")) {
            verificationDnsRecords = serializer.deserializeObject(json.get("verificationDnsRecords").toString(), DomainDnsRecordCollectionPage.class);
        }
    }
}
