/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Presence;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPresenceRequest;
import java.util.List;

public class PresenceRequest
extends BaseRequest
implements IPresenceRequest {
    public PresenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Presence.class);
    }

    @Override
    public void get(ICallback<? super Presence> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Presence get() throws ClientException {
        return (Presence)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super Presence> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Presence sourcePresence, ICallback<? super Presence> callback) {
        this.send(HttpMethod.PATCH, callback, sourcePresence);
    }

    @Override
    public Presence patch(Presence sourcePresence) throws ClientException {
        return (Presence)this.send(HttpMethod.PATCH, sourcePresence);
    }

    @Override
    public void post(Presence newPresence, ICallback<? super Presence> callback) {
        this.send(HttpMethod.POST, callback, newPresence);
    }

    @Override
    public Presence post(Presence newPresence) throws ClientException {
        return (Presence)this.send(HttpMethod.POST, newPresence);
    }

    @Override
    public void put(Presence newPresence, ICallback<? super Presence> callback) {
        this.send(HttpMethod.PUT, callback, newPresence);
    }

    @Override
    public Presence put(Presence newPresence) throws ClientException {
        return (Presence)this.send(HttpMethod.PUT, newPresence);
    }

    @Override
    public IPresenceRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPresenceRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

