/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.GroupSetting;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.GroupSettingCollectionPage;
import com.microsoft.graph.requests.extensions.GroupSettingCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.GroupSettingCollectionResponse;
import com.microsoft.graph.requests.extensions.GroupSettingRequestBuilder;
import com.microsoft.graph.requests.extensions.IGroupSettingCollectionPage;
import com.microsoft.graph.requests.extensions.IGroupSettingCollectionRequest;
import java.util.List;

public class GroupSettingCollectionRequest
extends BaseCollectionRequest<GroupSettingCollectionResponse, IGroupSettingCollectionPage>
implements IGroupSettingCollectionRequest {
    public GroupSettingCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, GroupSettingCollectionResponse.class, IGroupSettingCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IGroupSettingCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(GroupSettingCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IGroupSettingCollectionPage get() throws ClientException {
        GroupSettingCollectionResponse response = (GroupSettingCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(GroupSetting newGroupSetting, ICallback<? super GroupSetting> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new GroupSettingRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newGroupSetting, callback);
    }

    @Override
    public GroupSetting post(GroupSetting newGroupSetting) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new GroupSettingRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newGroupSetting);
    }

    @Override
    public IGroupSettingCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IGroupSettingCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IGroupSettingCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IGroupSettingCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IGroupSettingCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IGroupSettingCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IGroupSettingCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IGroupSettingCollectionPage buildFromResponse(GroupSettingCollectionResponse response) {
        GroupSettingCollectionRequestBuilder builder = response.nextLink != null ? new GroupSettingCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        GroupSettingCollectionPage page = new GroupSettingCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

