// Template Source: BaseEntityCollectionRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.Todo;
import com.microsoft.graph.models.extensions.TodoTaskList;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.requests.extensions.ITodoTaskListCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ITodoTaskListRequestBuilder;
import com.microsoft.graph.requests.extensions.ITodoTaskListCollectionRequest;
import com.microsoft.graph.requests.extensions.ITodoTaskListDeltaCollectionRequestBuilder;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.core.IBaseClient;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Todo Task List Collection Request Builder.
 */
public class TodoTaskListCollectionRequestBuilder extends BaseRequestBuilder implements ITodoTaskListCollectionRequestBuilder {

    /**
     * The request builder for this collection of Todo
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TodoTaskListCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IUserRequest instance
     */
    public ITodoTaskListCollectionRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IUserRequest instance
     */
    public ITodoTaskListCollectionRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new TodoTaskListCollectionRequest(getRequestUrl(), getClient(), requestOptions);
    }

    public ITodoTaskListRequestBuilder byId(final String id) {
        return new TodoTaskListRequestBuilder(getRequestUrlWithAdditionalSegment(id), getClient(), getOptions());
    }



    public ITodoTaskListDeltaCollectionRequestBuilder delta() {
        return new TodoTaskListDeltaCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.delta"), getClient(), null);
    }

	public ITodoTaskListDeltaCollectionRequestBuilder delta(final String deltaLink) {
        return new TodoTaskListDeltaCollectionRequestBuilder(deltaLink, getClient(), null);
    }
}
