// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.ThreatAssessmentRequest;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Threat Assessment Request Request.
 */
public interface IThreatAssessmentRequestRequest extends IHttpRequest {

    /**
     * Gets the ThreatAssessmentRequest from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super ThreatAssessmentRequest> callback);

    /**
     * Gets the ThreatAssessmentRequest from the service
     *
     * @return the ThreatAssessmentRequest from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ThreatAssessmentRequest get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super ThreatAssessmentRequest> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ThreatAssessmentRequest with a source
     *
     * @param sourceThreatAssessmentRequest the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final ThreatAssessmentRequest sourceThreatAssessmentRequest, final ICallback<? super ThreatAssessmentRequest> callback);

    /**
     * Patches this ThreatAssessmentRequest with a source
     *
     * @param sourceThreatAssessmentRequest the source object with updates
     * @return the updated ThreatAssessmentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ThreatAssessmentRequest patch(final ThreatAssessmentRequest sourceThreatAssessmentRequest) throws ClientException;

    /**
     * Posts a ThreatAssessmentRequest with a new object
     *
     * @param newThreatAssessmentRequest the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final ThreatAssessmentRequest newThreatAssessmentRequest, final ICallback<? super ThreatAssessmentRequest> callback);

    /**
     * Posts a ThreatAssessmentRequest with a new object
     *
     * @param newThreatAssessmentRequest the new object to create
     * @return the created ThreatAssessmentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ThreatAssessmentRequest post(final ThreatAssessmentRequest newThreatAssessmentRequest) throws ClientException;

    /**
     * Posts a ThreatAssessmentRequest with a new object
     *
     * @param newThreatAssessmentRequest the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final ThreatAssessmentRequest newThreatAssessmentRequest, final ICallback<? super ThreatAssessmentRequest> callback);

    /**
     * Posts a ThreatAssessmentRequest with a new object
     *
     * @param newThreatAssessmentRequest the object to create/update
     * @return the created ThreatAssessmentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ThreatAssessmentRequest put(final ThreatAssessmentRequest newThreatAssessmentRequest) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IThreatAssessmentRequestRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IThreatAssessmentRequestRequest expand(final String value);

}

