// Template Source: IBaseEntityReferenceRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.ItemActivityStat;
import com.microsoft.graph.requests.extensions.IItemActivityCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IItemActivityRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.models.extensions.ItemActivityStat;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Item Activity Stat Reference Request.
 */
public interface IItemActivityStatReferenceRequest extends IHttpRequest {

    void delete(final ICallback<? super ItemActivityStat> callback);

    ItemActivityStat delete() throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IItemActivityStatReferenceRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IItemActivityStatReferenceRequest expand(final String value);

    /**
     * Puts the ItemActivityStat
     *
     * @param srcItemActivityStat the ItemActivityStat to PUT
     * @param callback the callback to be called after success or failure
     */
    void put(ItemActivityStat srcItemActivityStat, final ICallback<? super ItemActivityStat> callback);

    /**
     * Puts the ItemActivityStat
     *
     * @param srcItemActivityStat the ItemActivityStat to PUT
     * @return the ItemActivityStat
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    ItemActivityStat put(ItemActivityStat srcItemActivityStat) throws ClientException;
}
