/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ResourceSpecificPermissionGrant;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IResourceSpecificPermissionGrantCollectionPage;
import com.microsoft.graph.requests.extensions.IResourceSpecificPermissionGrantCollectionRequest;
import com.microsoft.graph.requests.extensions.ResourceSpecificPermissionGrantCollectionPage;
import com.microsoft.graph.requests.extensions.ResourceSpecificPermissionGrantCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ResourceSpecificPermissionGrantCollectionResponse;
import com.microsoft.graph.requests.extensions.ResourceSpecificPermissionGrantRequestBuilder;
import java.util.List;

public class ResourceSpecificPermissionGrantCollectionRequest
extends BaseCollectionRequest<ResourceSpecificPermissionGrantCollectionResponse, IResourceSpecificPermissionGrantCollectionPage>
implements IResourceSpecificPermissionGrantCollectionRequest {
    public ResourceSpecificPermissionGrantCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ResourceSpecificPermissionGrantCollectionResponse.class, IResourceSpecificPermissionGrantCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IResourceSpecificPermissionGrantCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ResourceSpecificPermissionGrantCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IResourceSpecificPermissionGrantCollectionPage get() throws ClientException {
        ResourceSpecificPermissionGrantCollectionResponse response = (ResourceSpecificPermissionGrantCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ResourceSpecificPermissionGrant newResourceSpecificPermissionGrant, ICallback<? super ResourceSpecificPermissionGrant> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ResourceSpecificPermissionGrantRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newResourceSpecificPermissionGrant, callback);
    }

    @Override
    public ResourceSpecificPermissionGrant post(ResourceSpecificPermissionGrant newResourceSpecificPermissionGrant) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ResourceSpecificPermissionGrantRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newResourceSpecificPermissionGrant);
    }

    @Override
    public IResourceSpecificPermissionGrantCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IResourceSpecificPermissionGrantCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IResourceSpecificPermissionGrantCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IResourceSpecificPermissionGrantCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IResourceSpecificPermissionGrantCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IResourceSpecificPermissionGrantCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IResourceSpecificPermissionGrantCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IResourceSpecificPermissionGrantCollectionPage buildFromResponse(ResourceSpecificPermissionGrantCollectionResponse response) {
        ResourceSpecificPermissionGrantCollectionRequestBuilder builder = response.nextLink != null ? new ResourceSpecificPermissionGrantCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ResourceSpecificPermissionGrantCollectionPage page = new ResourceSpecificPermissionGrantCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

