/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Operation;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IOperationRequest;
import java.util.List;

public class OperationRequest
extends BaseRequest
implements IOperationRequest {
    public OperationRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, Class<? extends Operation> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    public OperationRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Operation.class);
    }

    @Override
    public void get(ICallback<? super Operation> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Operation get() throws ClientException {
        return (Operation)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super Operation> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Operation sourceOperation, ICallback<? super Operation> callback) {
        this.send(HttpMethod.PATCH, callback, sourceOperation);
    }

    @Override
    public Operation patch(Operation sourceOperation) throws ClientException {
        return (Operation)this.send(HttpMethod.PATCH, sourceOperation);
    }

    @Override
    public void post(Operation newOperation, ICallback<? super Operation> callback) {
        this.send(HttpMethod.POST, callback, newOperation);
    }

    @Override
    public Operation post(Operation newOperation) throws ClientException {
        return (Operation)this.send(HttpMethod.POST, newOperation);
    }

    @Override
    public void put(Operation newOperation, ICallback<? super Operation> callback) {
        this.send(HttpMethod.PUT, callback, newOperation);
    }

    @Override
    public Operation put(Operation newOperation) throws ClientException {
        return (Operation)this.send(HttpMethod.PUT, newOperation);
    }

    @Override
    public IOperationRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IOperationRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

