// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.Site;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.requests.extensions.ISiteAddCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.SiteAddCollectionPage;
import com.microsoft.graph.requests.extensions.SiteAddCollectionResponse;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.IBaseCollectionPage;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Site Add Collection Page.
 */
public class SiteAddCollectionPage extends BaseCollectionPage<Site, ISiteAddCollectionRequestBuilder> implements ISiteAddCollectionPage {

    /**
     * A collection page for Site.
     *
     * @param response The serialized SiteAddCollectionResponse from the service
     * @param builder The request builder for the next collection page
     */
    public SiteAddCollectionPage(final SiteAddCollectionResponse response, final ISiteAddCollectionRequestBuilder builder) {
       super(response.value, builder, response.additionalDataManager());
    }
}
