// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IManagedDeviceWindowsDefenderScanRequest;
import com.microsoft.graph.requests.extensions.ManagedDeviceWindowsDefenderScanRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed Device Windows Defender Scan Request Builder.
 */
public class ManagedDeviceWindowsDefenderScanRequestBuilder extends BaseActionRequestBuilder implements IManagedDeviceWindowsDefenderScanRequestBuilder {

    /**
     * The request builder for this ManagedDeviceWindowsDefenderScan
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param quickScan the quickScan
     */
    public ManagedDeviceWindowsDefenderScanRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, final Boolean quickScan) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("quickScan", quickScan);
    }

    /**
     * Creates the IManagedDeviceWindowsDefenderScanRequest
     *
     * @param requestOptions the options for the request
     * @return the IManagedDeviceWindowsDefenderScanRequest instance
     */
    public IManagedDeviceWindowsDefenderScanRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the IManagedDeviceWindowsDefenderScanRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IManagedDeviceWindowsDefenderScanRequest instance
     */
    public IManagedDeviceWindowsDefenderScanRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        ManagedDeviceWindowsDefenderScanRequest request = new ManagedDeviceWindowsDefenderScanRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("quickScan")) {
            request.body.quickScan = getParameter("quickScan");
        }

        return request;
    }
}
