// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WorkbookChartLegendFormat;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Chart Legend Format Request.
 */
public interface IWorkbookChartLegendFormatRequest extends IHttpRequest {

    /**
     * Gets the WorkbookChartLegendFormat from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super WorkbookChartLegendFormat> callback);

    /**
     * Gets the WorkbookChartLegendFormat from the service
     *
     * @return the WorkbookChartLegendFormat from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartLegendFormat get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super WorkbookChartLegendFormat> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookChartLegendFormat with a source
     *
     * @param sourceWorkbookChartLegendFormat the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final WorkbookChartLegendFormat sourceWorkbookChartLegendFormat, final ICallback<? super WorkbookChartLegendFormat> callback);

    /**
     * Patches this WorkbookChartLegendFormat with a source
     *
     * @param sourceWorkbookChartLegendFormat the source object with updates
     * @return the updated WorkbookChartLegendFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartLegendFormat patch(final WorkbookChartLegendFormat sourceWorkbookChartLegendFormat) throws ClientException;

    /**
     * Posts a WorkbookChartLegendFormat with a new object
     *
     * @param newWorkbookChartLegendFormat the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final WorkbookChartLegendFormat newWorkbookChartLegendFormat, final ICallback<? super WorkbookChartLegendFormat> callback);

    /**
     * Posts a WorkbookChartLegendFormat with a new object
     *
     * @param newWorkbookChartLegendFormat the new object to create
     * @return the created WorkbookChartLegendFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartLegendFormat post(final WorkbookChartLegendFormat newWorkbookChartLegendFormat) throws ClientException;

    /**
     * Posts a WorkbookChartLegendFormat with a new object
     *
     * @param newWorkbookChartLegendFormat the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final WorkbookChartLegendFormat newWorkbookChartLegendFormat, final ICallback<? super WorkbookChartLegendFormat> callback);

    /**
     * Posts a WorkbookChartLegendFormat with a new object
     *
     * @param newWorkbookChartLegendFormat the object to create/update
     * @return the created WorkbookChartLegendFormat
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartLegendFormat put(final WorkbookChartLegendFormat newWorkbookChartLegendFormat) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWorkbookChartLegendFormatRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWorkbookChartLegendFormatRequest expand(final String value);

}

