// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.TeamsAppDefinition;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Teams App Definition Request.
 */
public interface ITeamsAppDefinitionRequest extends IHttpRequest {

    /**
     * Gets the TeamsAppDefinition from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super TeamsAppDefinition> callback);

    /**
     * Gets the TeamsAppDefinition from the service
     *
     * @return the TeamsAppDefinition from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TeamsAppDefinition get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super TeamsAppDefinition> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this TeamsAppDefinition with a source
     *
     * @param sourceTeamsAppDefinition the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final TeamsAppDefinition sourceTeamsAppDefinition, final ICallback<? super TeamsAppDefinition> callback);

    /**
     * Patches this TeamsAppDefinition with a source
     *
     * @param sourceTeamsAppDefinition the source object with updates
     * @return the updated TeamsAppDefinition
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TeamsAppDefinition patch(final TeamsAppDefinition sourceTeamsAppDefinition) throws ClientException;

    /**
     * Posts a TeamsAppDefinition with a new object
     *
     * @param newTeamsAppDefinition the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final TeamsAppDefinition newTeamsAppDefinition, final ICallback<? super TeamsAppDefinition> callback);

    /**
     * Posts a TeamsAppDefinition with a new object
     *
     * @param newTeamsAppDefinition the new object to create
     * @return the created TeamsAppDefinition
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TeamsAppDefinition post(final TeamsAppDefinition newTeamsAppDefinition) throws ClientException;

    /**
     * Posts a TeamsAppDefinition with a new object
     *
     * @param newTeamsAppDefinition the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final TeamsAppDefinition newTeamsAppDefinition, final ICallback<? super TeamsAppDefinition> callback);

    /**
     * Posts a TeamsAppDefinition with a new object
     *
     * @param newTeamsAppDefinition the object to create/update
     * @return the created TeamsAppDefinition
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TeamsAppDefinition put(final TeamsAppDefinition newTeamsAppDefinition) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ITeamsAppDefinitionRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ITeamsAppDefinitionRequest expand(final String value);

}

