// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.DeviceCategory;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Device Category Request.
 */
public interface IDeviceCategoryRequest extends IHttpRequest {

    /**
     * Gets the DeviceCategory from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super DeviceCategory> callback);

    /**
     * Gets the DeviceCategory from the service
     *
     * @return the DeviceCategory from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceCategory get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super DeviceCategory> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this DeviceCategory with a source
     *
     * @param sourceDeviceCategory the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final DeviceCategory sourceDeviceCategory, final ICallback<? super DeviceCategory> callback);

    /**
     * Patches this DeviceCategory with a source
     *
     * @param sourceDeviceCategory the source object with updates
     * @return the updated DeviceCategory
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceCategory patch(final DeviceCategory sourceDeviceCategory) throws ClientException;

    /**
     * Posts a DeviceCategory with a new object
     *
     * @param newDeviceCategory the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final DeviceCategory newDeviceCategory, final ICallback<? super DeviceCategory> callback);

    /**
     * Posts a DeviceCategory with a new object
     *
     * @param newDeviceCategory the new object to create
     * @return the created DeviceCategory
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceCategory post(final DeviceCategory newDeviceCategory) throws ClientException;

    /**
     * Posts a DeviceCategory with a new object
     *
     * @param newDeviceCategory the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final DeviceCategory newDeviceCategory, final ICallback<? super DeviceCategory> callback);

    /**
     * Posts a DeviceCategory with a new object
     *
     * @param newDeviceCategory the object to create/update
     * @return the created DeviceCategory
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceCategory put(final DeviceCategory newDeviceCategory) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IDeviceCategoryRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IDeviceCategoryRequest expand(final String value);

}

