// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.AppRoleAssignment;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the App Role Assignment Request.
 */
public interface IAppRoleAssignmentRequest extends IHttpRequest {

    /**
     * Gets the AppRoleAssignment from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super AppRoleAssignment> callback);

    /**
     * Gets the AppRoleAssignment from the service
     *
     * @return the AppRoleAssignment from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AppRoleAssignment get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super AppRoleAssignment> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this AppRoleAssignment with a source
     *
     * @param sourceAppRoleAssignment the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final AppRoleAssignment sourceAppRoleAssignment, final ICallback<? super AppRoleAssignment> callback);

    /**
     * Patches this AppRoleAssignment with a source
     *
     * @param sourceAppRoleAssignment the source object with updates
     * @return the updated AppRoleAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AppRoleAssignment patch(final AppRoleAssignment sourceAppRoleAssignment) throws ClientException;

    /**
     * Posts a AppRoleAssignment with a new object
     *
     * @param newAppRoleAssignment the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final AppRoleAssignment newAppRoleAssignment, final ICallback<? super AppRoleAssignment> callback);

    /**
     * Posts a AppRoleAssignment with a new object
     *
     * @param newAppRoleAssignment the new object to create
     * @return the created AppRoleAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AppRoleAssignment post(final AppRoleAssignment newAppRoleAssignment) throws ClientException;

    /**
     * Posts a AppRoleAssignment with a new object
     *
     * @param newAppRoleAssignment the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final AppRoleAssignment newAppRoleAssignment, final ICallback<? super AppRoleAssignment> callback);

    /**
     * Posts a AppRoleAssignment with a new object
     *
     * @param newAppRoleAssignment the object to create/update
     * @return the created AppRoleAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AppRoleAssignment put(final AppRoleAssignment newAppRoleAssignment) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IAppRoleAssignmentRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IAppRoleAssignmentRequest expand(final String value);

}

