// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Number Column.
 */
public class NumberColumn implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Decimal Places.
     * How many decimal places to display. See below for information about the possible values.
     */
    @SerializedName(value = "decimalPlaces", alternate = {"DecimalPlaces"})
    @Expose
    public String decimalPlaces;

    /**
     * The Display As.
     * How the value should be presented in the UX. Must be one of number or percentage. If unspecified, treated as number.
     */
    @SerializedName(value = "displayAs", alternate = {"DisplayAs"})
    @Expose
    public String displayAs;

    /**
     * The Maximum.
     * The maximum permitted value.
     */
    @SerializedName(value = "maximum", alternate = {"Maximum"})
    @Expose
    public Double maximum;

    /**
     * The Minimum.
     * The minimum permitted value.
     */
    @SerializedName(value = "minimum", alternate = {"Minimum"})
    @Expose
    public Double minimum;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
