// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.generated.MediaDirection;
import com.microsoft.graph.models.generated.Modality;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Media Stream.
 */
public class MediaStream implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Direction.
     * The direction. The possible values are inactive, sendOnly, receiveOnly, sendReceive.
     */
    @SerializedName(value = "direction", alternate = {"Direction"})
    @Expose
    public MediaDirection direction;

    /**
     * The Label.
     * The media stream label.
     */
    @SerializedName(value = "label", alternate = {"Label"})
    @Expose
    public String label;

    /**
     * The Media Type.
     * The media type. The possible value are unknown, audio, video, videoBasedScreenSharing, data.
     */
    @SerializedName(value = "mediaType", alternate = {"MediaType"})
    @Expose
    public Modality mediaType;

    /**
     * The Server Muted.
     * If the media is muted by the server.
     */
    @SerializedName(value = "serverMuted", alternate = {"ServerMuted"})
    @Expose
    public Boolean serverMuted;

    /**
     * The Source Id.
     * The source ID.
     */
    @SerializedName(value = "sourceId", alternate = {"SourceId"})
    @Expose
    public String sourceId;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
