// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IWorkbookRangeFormatAutofitColumnsRequest;
import com.microsoft.graph.requests.extensions.WorkbookRangeFormatAutofitColumnsRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Range Format Autofit Columns Request Builder.
 */
public class WorkbookRangeFormatAutofitColumnsRequestBuilder extends BaseActionRequestBuilder implements IWorkbookRangeFormatAutofitColumnsRequestBuilder {

    /**
     * The request builder for this WorkbookRangeFormatAutofitColumns
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookRangeFormatAutofitColumnsRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the IWorkbookRangeFormatAutofitColumnsRequest
     *
     * @param requestOptions the options for the request
     * @return the IWorkbookRangeFormatAutofitColumnsRequest instance
     */
    public IWorkbookRangeFormatAutofitColumnsRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the IWorkbookRangeFormatAutofitColumnsRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IWorkbookRangeFormatAutofitColumnsRequest instance
     */
    public IWorkbookRangeFormatAutofitColumnsRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        WorkbookRangeFormatAutofitColumnsRequest request = new WorkbookRangeFormatAutofitColumnsRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        return request;
    }
}
