// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.TodoTask;
import com.microsoft.graph.requests.extensions.IExtensionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IExtensionRequestBuilder;
import com.microsoft.graph.requests.extensions.ExtensionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ExtensionRequestBuilder;
import com.microsoft.graph.requests.extensions.ILinkedResourceCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ILinkedResourceRequestBuilder;
import com.microsoft.graph.requests.extensions.LinkedResourceCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.LinkedResourceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Todo Task Request.
 */
public class TodoTaskRequest extends BaseRequest implements ITodoTaskRequest {
	
    /**
     * The request for the TodoTask
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TodoTaskRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TodoTask.class);
    }

    /**
     * Gets the TodoTask from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super TodoTask> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the TodoTask from the service
     *
     * @return the TodoTask from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public TodoTask get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super TodoTask> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this TodoTask with a source
     *
     * @param sourceTodoTask the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final TodoTask sourceTodoTask, final ICallback<? super TodoTask> callback) {
        send(HttpMethod.PATCH, callback, sourceTodoTask);
    }

    /**
     * Patches this TodoTask with a source
     *
     * @param sourceTodoTask the source object with updates
     * @return the updated TodoTask
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public TodoTask patch(final TodoTask sourceTodoTask) throws ClientException {
        return send(HttpMethod.PATCH, sourceTodoTask);
    }

    /**
     * Creates a TodoTask with a new object
     *
     * @param newTodoTask the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final TodoTask newTodoTask, final ICallback<? super TodoTask> callback) {
        send(HttpMethod.POST, callback, newTodoTask);
    }

    /**
     * Creates a TodoTask with a new object
     *
     * @param newTodoTask the new object to create
     * @return the created TodoTask
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public TodoTask post(final TodoTask newTodoTask) throws ClientException {
        return send(HttpMethod.POST, newTodoTask);
    }

    /**
     * Creates a TodoTask with a new object
     *
     * @param newTodoTask the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final TodoTask newTodoTask, final ICallback<? super TodoTask> callback) {
        send(HttpMethod.PUT, callback, newTodoTask);
    }

    /**
     * Creates a TodoTask with a new object
     *
     * @param newTodoTask the object to create/update
     * @return the created TodoTask
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public TodoTask put(final TodoTask newTodoTask) throws ClientException {
        return send(HttpMethod.PUT, newTodoTask);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public ITodoTaskRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (TodoTaskRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public ITodoTaskRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (TodoTaskRequest)this;
     }

}

