// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.TodoTaskList;
import com.microsoft.graph.requests.extensions.IExtensionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IExtensionRequestBuilder;
import com.microsoft.graph.requests.extensions.ExtensionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ExtensionRequestBuilder;
import com.microsoft.graph.requests.extensions.ITodoTaskCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ITodoTaskRequestBuilder;
import com.microsoft.graph.requests.extensions.TodoTaskCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TodoTaskRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Todo Task List Request.
 */
public class TodoTaskListRequest extends BaseRequest implements ITodoTaskListRequest {
	
    /**
     * The request for the TodoTaskList
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TodoTaskListRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TodoTaskList.class);
    }

    /**
     * Gets the TodoTaskList from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super TodoTaskList> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the TodoTaskList from the service
     *
     * @return the TodoTaskList from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public TodoTaskList get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super TodoTaskList> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this TodoTaskList with a source
     *
     * @param sourceTodoTaskList the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final TodoTaskList sourceTodoTaskList, final ICallback<? super TodoTaskList> callback) {
        send(HttpMethod.PATCH, callback, sourceTodoTaskList);
    }

    /**
     * Patches this TodoTaskList with a source
     *
     * @param sourceTodoTaskList the source object with updates
     * @return the updated TodoTaskList
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public TodoTaskList patch(final TodoTaskList sourceTodoTaskList) throws ClientException {
        return send(HttpMethod.PATCH, sourceTodoTaskList);
    }

    /**
     * Creates a TodoTaskList with a new object
     *
     * @param newTodoTaskList the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final TodoTaskList newTodoTaskList, final ICallback<? super TodoTaskList> callback) {
        send(HttpMethod.POST, callback, newTodoTaskList);
    }

    /**
     * Creates a TodoTaskList with a new object
     *
     * @param newTodoTaskList the new object to create
     * @return the created TodoTaskList
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public TodoTaskList post(final TodoTaskList newTodoTaskList) throws ClientException {
        return send(HttpMethod.POST, newTodoTaskList);
    }

    /**
     * Creates a TodoTaskList with a new object
     *
     * @param newTodoTaskList the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final TodoTaskList newTodoTaskList, final ICallback<? super TodoTaskList> callback) {
        send(HttpMethod.PUT, callback, newTodoTaskList);
    }

    /**
     * Creates a TodoTaskList with a new object
     *
     * @param newTodoTaskList the object to create/update
     * @return the created TodoTaskList
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public TodoTaskList put(final TodoTaskList newTodoTaskList) throws ClientException {
        return send(HttpMethod.PUT, newTodoTaskList);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public ITodoTaskListRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (TodoTaskListRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public ITodoTaskListRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (TodoTaskListRequest)this;
     }

}

