// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IReportRootGetYammerGroupsActivityGroupCountsRequest;
import com.microsoft.graph.requests.extensions.ReportRootGetYammerGroupsActivityGroupCountsRequest;
import com.microsoft.graph.models.extensions.Report;
import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Report Root Get Yammer Groups Activity Group Counts Request Builder.
 */
public class ReportRootGetYammerGroupsActivityGroupCountsRequestBuilder extends BaseFunctionRequestBuilder implements IReportRootGetYammerGroupsActivityGroupCountsRequestBuilder {

    /**
     * The request builder for this ReportRootGetYammerGroupsActivityGroupCounts
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param period the period
     */
    public ReportRootGetYammerGroupsActivityGroupCountsRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, final String period) {
        super(requestUrl, client, requestOptions);
        functionOptions.add(new com.microsoft.graph.options.FunctionOption("period", period));
    }

    /**
     * Creates the IReportRootGetYammerGroupsActivityGroupCountsRequest
     *
     * @param requestOptions the options for the request
     * @return the IReportRootGetYammerGroupsActivityGroupCountsRequest instance
     */
    public IReportRootGetYammerGroupsActivityGroupCountsRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the IReportRootGetYammerGroupsActivityGroupCountsRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IReportRootGetYammerGroupsActivityGroupCountsRequest instance
     */
    public IReportRootGetYammerGroupsActivityGroupCountsRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        ReportRootGetYammerGroupsActivityGroupCountsRequest request = new ReportRootGetYammerGroupsActivityGroupCountsRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

      for (com.microsoft.graph.options.FunctionOption option : functionOptions) {
            request.addFunctionOption(option);
      }

        return request;
    }
}
