// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IReportRootDeviceConfigurationDeviceActivityRequest;
import com.microsoft.graph.requests.extensions.ReportRootDeviceConfigurationDeviceActivityRequest;
import com.microsoft.graph.models.extensions.Report;
import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Report Root Device Configuration Device Activity Request Builder.
 */
public class ReportRootDeviceConfigurationDeviceActivityRequestBuilder extends BaseFunctionRequestBuilder implements IReportRootDeviceConfigurationDeviceActivityRequestBuilder {

    /**
     * The request builder for this ReportRootDeviceConfigurationDeviceActivity
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ReportRootDeviceConfigurationDeviceActivityRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the IReportRootDeviceConfigurationDeviceActivityRequest
     *
     * @param requestOptions the options for the request
     * @return the IReportRootDeviceConfigurationDeviceActivityRequest instance
     */
    public IReportRootDeviceConfigurationDeviceActivityRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the IReportRootDeviceConfigurationDeviceActivityRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IReportRootDeviceConfigurationDeviceActivityRequest instance
     */
    public IReportRootDeviceConfigurationDeviceActivityRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        ReportRootDeviceConfigurationDeviceActivityRequest request = new ReportRootDeviceConfigurationDeviceActivityRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

      for (com.microsoft.graph.options.FunctionOption option : functionOptions) {
            request.addFunctionOption(option);
      }

        return request;
    }
}
